<?php
/** cms-core/backend/authorization/check_permission.php */

/**
 * Permission Check Helper
 * Use in any admin page to require specific permissions
 */

require_once __DIR__ . '/../core/init.php';
require_once __DIR__ . '/../auth/UserRoles.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: /admin/login.php');
    exit;
}

/**
 * Helper function to check permission
 * Usage: can('pages.edit') or can('blog.delete')
 */
function can($permission) {
    return UserRoles::can($permission);
}

/**
 * Helper function to require permission
 * Usage: require_permission('pages.delete');
 */
function require_permission($permission, $message = null) {
    UserRoles::require($permission, $message);
}

/**
 * Helper function to check if user is admin
 */
function is_admin() {
    return UserRoles::isAdmin();
}

/**
 * Helper function to check if user is super admin
 */
function is_super_admin() {
    $user = UserRoles::getUser($_SESSION['user_id']);
    return $user && $user['role'] === 'super_admin';
}

/**
 * Helper function to check if user owns resource
 */
function owns($resourceType, $resourceId) {
    return UserRoles::owns($resourceType, $resourceId);
}

/**
 * Get current user
 */
function current_user() {
    return UserRoles::getUser($_SESSION['user_id']);
}

/**
 * Get current user role
 */
function current_role() {
    $user = current_user();
    return $user ? $user['role'] : null;
}