<?php
/** cms-core/backend/authorization/check_role.php */

/**
 * Role-Based Access Control
 * Prüft Benutzer-Rollen
 */

class RoleChecker {
    
    /**
     * Verfügbare Rollen (in Hierarchie)
     */
    const ROLES = [
        'user' => 1,
        'editor' => 2,
        'admin' => 3
    ];
    
    /**
     * Prüft ob User eine bestimmte Rolle hat
     */
    public static function hasRole($requiredRole) {
        $user = current_user();
        
        if (!$user) {
            return false;
        }
        
        $userRole = $user['role'] ?? 'user';
        
        return $userRole === $requiredRole;
    }
    
    /**
     * Prüft ob User mindestens eine bestimmte Rolle hat
     */
    public static function hasMinimumRole($requiredRole) {
        $user = current_user();
        
        if (!$user) {
            return false;
        }
        
        $userRole = $user['role'] ?? 'user';
        
        $userLevel = self::ROLES[$userRole] ?? 0;
        $requiredLevel = self::ROLES[$requiredRole] ?? 999;
        
        return $userLevel >= $requiredLevel;
    }
    
    /**
     * Erzwingt minimale Rolle
     */
    public static function requireRole($requiredRole) {
        if (!self::hasMinimumRole($requiredRole)) {
            http_response_code(403);
            die('Zugriff verweigert. Erforderliche Rolle: ' . $requiredRole);
        }
    }
    
    /**
     * Prüft ob User Ressource bearbeiten darf
     */
    public static function canEdit($resourceOwnerId) {
        $user = current_user();
        
        if (!$user) {
            return false;
        }
        
        // Admins dürfen alles
        if ($user['role'] === 'admin') {
            return true;
        }
        
        // Owner darf eigene Ressourcen bearbeiten
        return (int)$user['id'] === (int)$resourceOwnerId;
    }
}