<?php
/**
 * cms-core/backend/core/hooks/sitemap_hooks.php
 * Automatic sitemap generation hooks
 * 
 * Add this to pages that save content:
 * require_once __DIR__ . '/../../../../backend/core/hooks/sitemap_hooks.php';
 * trigger_sitemap_generation();
 */

/**
 * Trigger sitemap generation (with throttle)
 */
function trigger_sitemap_generation() {
    // Only in production or when explicitly enabled
    if (APP_ENV !== 'production' && !defined('FORCE_SITEMAP_GENERATION')) {
        return false;
    }
    
    try {
        SitemapGenerator::autoGenerate();
        return true;
    } catch (Exception $e) {
        Logger::error('Auto-sitemap generation failed: ' . $e->getMessage());
        return false;
    }
}

/**
 * Can be called manually in admin pages after save:
 * 
 * Example in page_flexible_edit.php after successful save:
 * 
 * if ($saveSuccess) {
 *     trigger_sitemap_generation();
 *     set_flash('success', 'Seite gespeichert & Sitemap aktualisiert');
 * }
 */