<?php
/** cms-core/backend/core/maintenance_check.php */

/**
 * Wartungsmodus-Prüfung
 * Zeigt Wartungsseite für normale Besucher, aber nicht für Admins
 */

function check_maintenance_mode() {
    // Prüfe ob Wartungsmodus aktiv ist
    $maintenanceMode = get_setting('maintenance_mode', false);
    
    if (!$maintenanceMode) {
        return; // Wartungsmodus nicht aktiv
    }
    
    // Erlaube Admins Zugriff
    if (is_logged_in() && is_admin()) {
        return; // Admin darf weiterarbeiten
    }
    
    // Zeige Wartungsseite
    show_maintenance_page();
}

function show_maintenance_page() {
    http_response_code(503);
    header('Retry-After: 3600'); // In 1 Stunde erneut versuchen
    
    ?>
    <!DOCTYPE html>
    <html lang="de">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="robots" content="noindex, nofollow">
        <title>Wartungsarbeiten - KynoCanis</title>
        <style>
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }
            
            body {
                font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
                color: white;
            }
            
            .maintenance-container {
                text-align: center;
                max-width: 600px;
                background: rgba(255, 255, 255, 0.1);
                padding: 60px 40px;
                border-radius: 20px;
                backdrop-filter: blur(10px);
                box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            }
            
            .maintenance-icon {
                font-size: 120px;
                margin-bottom: 30px;
                animation: pulse 2s infinite;
            }
            
            @keyframes pulse {
                0%, 100% { transform: scale(1); }
                50% { transform: scale(1.1); }
            }
            
            h1 {
                font-size: 2.5rem;
                margin-bottom: 20px;
                font-weight: 700;
            }
            
            p {
                font-size: 1.2rem;
                line-height: 1.6;
                margin-bottom: 15px;
                opacity: 0.9;
            }
            
            .countdown {
                background: rgba(255, 255, 255, 0.2);
                padding: 20px;
                border-radius: 10px;
                margin-top: 30px;
                font-size: 1.1rem;
            }
            
            .admin-hint {
                margin-top: 40px;
                padding-top: 30px;
                border-top: 1px solid rgba(255, 255, 255, 0.3);
                font-size: 0.9rem;
                opacity: 0.7;
            }
            
            .admin-hint a {
                color: white;
                text-decoration: underline;
            }
            
            @media (max-width: 600px) {
                .maintenance-icon {
                    font-size: 80px;
                }
                
                h1 {
                    font-size: 2rem;
                }
                
                p {
                    font-size: 1rem;
                }
            }
        </style>
    </head>
    <body>
        <div class="maintenance-container">
            <div class="maintenance-icon">🔧</div>
            <h1>Wartungsarbeiten</h1>
            <p>Wir führen gerade wichtige Wartungsarbeiten durch.</p>
            <p>Die Website ist vorübergehend nicht verfügbar.</p>
            <p><strong>Wir sind bald wieder für Sie da!</strong></p>
            
            <div class="countdown">
                ⏰ Geschätzte Dauer: Wenige Stunden
            </div>
            
            <div class="admin-hint">
                Administrator? <a href="admin/login.php">Hier anmelden</a>
            </div>
        </div>
        
        <script>
        // Optional: Auto-Reload alle 5 Minuten
        setTimeout(function() {
            location.reload();
        }, 300000);
        </script>
    </body>
    </html>
    <?php
    exit;
}