<?php
/** cms-core/backend/core/router.php */

/**
 * Simple Router
 * Optionaler Router für saubere URLs (benötigt .htaccess)
 */

class Router {
    
    private $routes = [];
    
    /**
     * Registriert Route
     */
    public function add($method, $path, $handler) {
        $this->routes[] = [
            'method' => strtoupper($method),
            'path' => $path,
            'handler' => $handler
        ];
    }
    
    /**
     * GET-Route
     */
    public function get($path, $handler) {
        $this->add('GET', $path, $handler);
    }
    
    /**
     * POST-Route
     */
    public function post($path, $handler) {
        $this->add('POST', $path, $handler);
    }
    
    /**
     * Führt Router aus
     */
    public function run() {
        $method = $_SERVER['REQUEST_METHOD'];
        $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        
        foreach ($this->routes as $route) {
            if ($route['method'] === $method && $this->matchPath($route['path'], $uri)) {
                $params = $this->extractParams($route['path'], $uri);
                return call_user_func_array($route['handler'], $params);
            }
        }
        
        // 404
        http_response_code(404);
        echo '404 - Seite nicht gefunden';
    }
    
    /**
     * Prüft ob Pfad matcht
     */
    private function matchPath($routePath, $uri) {
        $pattern = preg_replace('/\{[a-zA-Z0-9_]+\}/', '([^/]+)', $routePath);
        $pattern = '#^' . $pattern . '$#';
        
        return preg_match($pattern, $uri);
    }
    
    /**
     * Extrahiert Parameter aus URI
     */
    private function extractParams($routePath, $uri) {
        $pattern = preg_replace('/\{[a-zA-Z0-9_]+\}/', '([^/]+)', $routePath);
        $pattern = '#^' . $pattern . '$#';
        
        preg_match($pattern, $uri, $matches);
        array_shift($matches); // Entferne ersten Match (komplette URI)
        
        return $matches;
    }
}