<?php
/** cms-core/backend/encryption/data_encrypt.php */

/**
 * Data Encryption
 * Verschlüsselt sensible Daten
 */

class DataEncryption {
    
    /**
     * Verschlüsselungsmethode
     */
    const METHOD = 'aes-256-gcm';
    
    /**
     * Verschlüsselt Daten
     */
    public static function encrypt($data) {
        $key = self::getKey();
        
        // Generiere IV (Initialization Vector)
        $ivLength = openssl_cipher_iv_length(self::METHOD);
        $iv = openssl_random_pseudo_bytes($ivLength);
        
        // Verschlüssele Daten
        $tag = '';
        $encrypted = openssl_encrypt(
            $data,
            self::METHOD,
            $key,
            OPENSSL_RAW_DATA,
            $iv,
            $tag
        );
        
        if ($encrypted === false) {
            throw new Exception('Verschlüsselung fehlgeschlagen');
        }
        
        // Kombiniere IV + Tag + verschlüsselte Daten
        $result = base64_encode($iv . $tag . $encrypted);
        
        return $result;
    }
    
    /**
     * Entschlüsselt Daten
     */
    public static function decrypt($encryptedData) {
        $key = self::getKey();
        
        // Decodiere Base64
        $data = base64_decode($encryptedData);
        
        // Extrahiere IV, Tag und verschlüsselte Daten
        $ivLength = openssl_cipher_iv_length(self::METHOD);
        $iv = substr($data, 0, $ivLength);
        $tag = substr($data, $ivLength, 16);
        $encrypted = substr($data, $ivLength + 16);
        
        // Entschlüssele
        $decrypted = openssl_decrypt(
            $encrypted,
            self::METHOD,
            $key,
            OPENSSL_RAW_DATA,
            $iv,
            $tag
        );
        
        if ($decrypted === false) {
            throw new Exception('Entschlüsselung fehlgeschlagen');
        }
        
        return $decrypted;
    }
    
    /**
     * Holt Verschlüsselungs-Key
     */
    private static function getKey() {
        $key = ENCRYPTION_KEY;
        
        if (strlen($key) < 32) {
            // Key zu kurz - erweitere mit Hash
            $key = hash('sha256', $key, true);
        } elseif (strlen($key) > 32) {
            // Key zu lang - kürze
            $key = substr($key, 0, 32);
        }
        
        return $key;
    }
    
    /**
     * Erstellt Hash von Daten (für Vergleiche)
     */
    public static function hash($data) {
        return hash('sha256', $data);
    }
}