<?php
/** cms-core/backend/integrations/cookie_consent.php - UPDATED ZALANDO STYLE */

/**
 * Cookie Consent Banner
 * DSGVO-konforme Cookie-Zustimmung mit modernem Design
 */

function render_cookie_consent() {
    if (!get_setting('cookie_consent_enabled', true)) {
        return '';
    }
    
    return <<<'HTML'
    <!-- Cookie Consent Overlay -->
    <div id='cookie-consent-overlay' style='display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0, 0, 0, 0.4); backdrop-filter: blur(2px); z-index: 9998; align-items: center; justify-content: center; padding: 20px;'>
        <div style='background: #000000; color: #ffffff; max-width: 520px; width: 100%; padding: 32px; border-radius: 12px; box-shadow: 0 20px 60px rgba(0, 0, 0, 0.6); animation: slideUp 0.3s ease-out;'>
            <h3 style='font-size: 20px; font-weight: 700; margin: 0 0 16px 0; color: #ffffff; line-height: 1.3;'>
                Cookies & Datenschutz
            </h3>
            
            <p style='font-size: 14px; line-height: 1.6; margin: 0 0 24px 0; color: #e5e5e5;'>
                Wir nutzen Cookies, um unsere Website zuverlässig zu betreiben und dein Erlebnis zu verbessern. 
                Mehr dazu in unserer <a href='/datenschutz' style='color: #ffffff; text-decoration: underline;'>Datenschutzerklärung</a> und im <a href='/impressum' style='color: #ffffff; text-decoration: underline;'>Impressum</a>.
            </p>
            
            <div style='display: flex; gap: 12px; flex-wrap: wrap; margin-bottom: 16px;'>
                <button onclick='acceptAllCookies()' style='flex: 1; min-width: 140px; padding: 14px 24px; border: none; border-radius: 8px; font-size: 14px; font-weight: 600; cursor: pointer; background: #ffffff; color: #000000; transition: all 0.2s;' onmouseover='this.style.background="#f0f0f0"; this.style.transform="translateY(-2px)"; this.style.boxShadow="0 4px 12px rgba(255,255,255,0.2)"' onmouseout='this.style.background="#ffffff"; this.style.transform=""; this.style.boxShadow=""'>
                    Alles akzeptieren
                </button>
            </div>
            
            <div style='display: flex; gap: 12px; flex-wrap: wrap;'>
                <button onclick='acceptEssentialOnly()' style='flex: 1; padding: 14px 24px; border: none; border-radius: 8px; font-size: 14px; font-weight: 600; cursor: pointer; background: transparent; color: #ffffff; transition: all 0.2s;' onmouseover='this.style.opacity="0.7"' onmouseout='this.style.opacity="1"'>
                    Nur Notwendige
                </button>
                <button onclick='toggleCookieDetails()' style='flex: 1; padding: 14px 24px; border: none; border-radius: 8px; font-size: 14px; font-weight: 600; cursor: pointer; background: transparent; color: #ffffff; transition: all 0.2s;' onmouseover='this.style.opacity="0.7"' onmouseout='this.style.opacity="1"'>
                    Einstellungen
                </button>
            </div>
            
            <!-- Erweiterte Einstellungen -->
            <div id='cookie-details' style='display: none; margin-top: 24px; padding-top: 24px; border-top: 1px solid rgba(255,255,255,0.2);'>
                <div style='margin-bottom: 20px;'>
                    <div style='display: flex; align-items: flex-start; gap: 12px; padding: 16px; background: rgba(255,255,255,0.05); border-radius: 8px; margin-bottom: 12px;'>
                        <input type='checkbox' id='essential-cookies' checked disabled style='width: 20px; height: 20px; margin-top: 2px; cursor: not-allowed;'>
                        <div style='flex: 1;'>
                            <label for='essential-cookies' style='font-weight: 600; font-size: 14px; display: block; margin-bottom: 4px; cursor: not-allowed;'>
                                Notwendige Cookies
                            </label>
                            <p style='margin: 0; font-size: 13px; opacity: 0.8; line-height: 1.4;'>
                                Erforderlich für grundlegende Funktionen. Können nicht deaktiviert werden.
                            </p>
                        </div>
                    </div>
                    
                    <div style='display: flex; align-items: flex-start; gap: 12px; padding: 16px; background: rgba(255,255,255,0.05); border-radius: 8px; margin-bottom: 12px;'>
                        <input type='checkbox' id='color-experiment-toggle' checked style='width: 20px; height: 20px; margin-top: 2px; cursor: pointer;'>
                        <div style='flex: 1;'>
                            <label for='color-experiment-toggle' style='font-weight: 600; font-size: 14px; display: block; margin-bottom: 4px; cursor: pointer;'>
                                Farbexperiment
                            </label>
                            <p style='margin: 0; font-size: 13px; opacity: 0.8; line-height: 1.4;'>
                                Anonymisiertes A/B-Testing zur Optimierung der Nutzererfahrung. IP-Anonymisierung, 7 Tage Speicherfrist.
                            </p>
                        </div>
                    </div>
                    
                    <div style='display: flex; align-items: flex-start; gap: 12px; padding: 16px; background: rgba(255,255,255,0.05); border-radius: 8px;'>
                        <input type='checkbox' id='analytics-toggle' checked style='width: 20px; height: 20px; margin-top: 2px; cursor: pointer;'>
                        <div style='flex: 1;'>
                            <label for='analytics-toggle' style='font-weight: 600; font-size: 14px; display: block; margin-bottom: 4px; cursor: pointer;'>
                                Analytics & Marketing
                            </label>
                            <p style='margin: 0; font-size: 13px; opacity: 0.8; line-height: 1.4;'>
                                Google Analytics, TikTok Pixel, Meta Pixel für Statistiken und personalisierte Werbung.
                            </p>
                        </div>
                    </div>
                </div>
                
                <button onclick='saveCustomPreferences()' style='width: 100%; padding: 14px 24px; border: none; border-radius: 8px; font-size: 14px; font-weight: 600; cursor: pointer; background: #ffffff; color: #000000; transition: all 0.2s;' onmouseover='this.style.background="#f0f0f0"' onmouseout='this.style.background="#ffffff"'>
                    Auswahl speichern
                </button>
            </div>
        </div>
    </div>
    
    <style>
    @keyframes slideUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    @media (max-width: 600px) {
        #cookie-consent-overlay > div {
            padding: 24px !important;
        }
        
        #cookie-consent-overlay h3 {
            font-size: 18px !important;
        }
        
        #cookie-consent-overlay p {
            font-size: 13px !important;
        }
        
        #cookie-consent-overlay button {
            width: 100% !important;
            min-width: 100% !important;
        }
    }
    </style>
    
    <script>
    (function() {
        'use strict';
        
        // Show overlay if no consent given
        if (!localStorage.getItem('cookieConsent')) {
            document.getElementById('cookie-consent-overlay').style.display = 'flex';
        }
        
        // Check color experiment opt-out
        const hasColorOptOut = document.cookie.includes('color_experiment_optout=1');
        if (hasColorOptOut) {
            const toggle = document.getElementById('color-experiment-toggle');
            if (toggle) toggle.checked = false;
        }
    })();
    
    function acceptAllCookies() {
        localStorage.setItem('cookieConsent', 'accepted');
        localStorage.setItem('cookiePreferences', JSON.stringify({
            essential: true,
            colorExperiment: true,
            analytics: true
        }));
        
        closeCookieConsent();
        loadTrackingScripts();
        showNotification('✓ Alle Cookies akzeptiert', 'success');
    }
    
    function acceptEssentialOnly() {
        localStorage.setItem('cookieConsent', 'essential');
        localStorage.setItem('cookiePreferences', JSON.stringify({
            essential: true,
            colorExperiment: false,
            analytics: false
        }));
        
        document.cookie = 'color_experiment_optout=1; path=/; max-age=' + (365 * 24 * 60 * 60);
        closeCookieConsent();
        showNotification('✓ Nur notwendige Cookies gespeichert', 'info');
    }
    
    function toggleCookieDetails() {
        const details = document.getElementById('cookie-details');
        if (details.style.display === 'none') {
            details.style.display = 'block';
        } else {
            details.style.display = 'none';
        }
    }
    
    function saveCustomPreferences() {
        const colorExperiment = document.getElementById('color-experiment-toggle').checked;
        const analytics = document.getElementById('analytics-toggle').checked;
        
        localStorage.setItem('cookieConsent', 'custom');
        localStorage.setItem('cookiePreferences', JSON.stringify({
            essential: true,
            colorExperiment: colorExperiment,
            analytics: analytics
        }));
        
        if (!colorExperiment) {
            document.cookie = 'color_experiment_optout=1; path=/; max-age=' + (365 * 24 * 60 * 60);
        } else {
            document.cookie = 'color_experiment_optout=; path=/; max-age=0';
        }
        
        closeCookieConsent();
        
        if (analytics) {
            loadTrackingScripts();
        }
        
        showNotification('✓ Präferenzen gespeichert', 'success');
        setTimeout(function() { location.reload(); }, 1000);
    }
    
    function closeCookieConsent() {
        document.getElementById('cookie-consent-overlay').style.display = 'none';
    }
    
    function loadTrackingScripts() {
        if (typeof loadGoogleAnalytics === 'function') loadGoogleAnalytics();
        if (typeof loadTikTokPixel === 'function') loadTikTokPixel();
        if (typeof loadMetaPixel === 'function') loadMetaPixel();
    }
    
    function showNotification(message, type) {
        const colors = {
            success: '#4CAF50',
            info: '#2196F3',
            warning: '#ff9800',
            error: '#f44336'
        };
        
        const notification = document.createElement('div');
        notification.textContent = message;
        notification.style.cssText = 'position: fixed; top: 20px; right: 20px; background: ' + (colors[type] || colors.info) + '; color: white; padding: 15px 25px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.3); z-index: 10000; font-size: 14px; font-weight: 600; animation: slideIn 0.3s ease-out;';
        
        document.body.appendChild(notification);
        
        setTimeout(function() {
            notification.style.animation = 'slideOut 0.3s ease-out';
            setTimeout(function() { notification.remove(); }, 300);
        }, 3000);
    }
    
    // Global function to reopen settings
    window.reopenCookieSettings = function() {
        document.getElementById('cookie-consent-overlay').style.display = 'flex';
        toggleCookieDetails();
    };
    </script>
HTML;
}