<?php
/** cms-core/backend/integrations/google_analytics.php */

/**
 * Google Analytics Integration
 * Bindet Google Analytics Code ein
 */

function render_google_analytics() {
    // Prüfe ob aktiviert und Cookie-Consent erteilt
    if (!IntegrationHelper::isActive('google_analytics')) {
        return '';
    }
    
    $trackingId = get_setting('google_analytics_id', '');
    
    if (empty($trackingId)) {
        return '';
    }
    
    // Prüfe Cookie-Consent
    $cookieConsentEnabled = get_setting('cookie_consent_enabled', true);
    
    if ($cookieConsentEnabled) {
        // Nur laden wenn Consent erteilt
        $consentCheck = "
        <script>
        if (localStorage.getItem('cookieConsent') === 'accepted') {
            loadGoogleAnalytics();
        }
        
        function loadGoogleAnalytics() {
            // Google Analytics Script
            var script1 = document.createElement('script');
            script1.async = true;
            script1.src = 'https://www.googletagmanager.com/gtag/js?id=" . e($trackingId) . "';
            document.head.appendChild(script1);
            
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', '" . e($trackingId) . "', {
                'anonymize_ip': true,
                'cookie_flags': 'SameSite=None;Secure'
            });
        }
        </script>
        ";
        
        return $consentCheck;
    } else {
        // Ohne Consent-Prüfung direkt laden
        return "
        <!-- Google Analytics -->
        <script async src='https://www.googletagmanager.com/gtag/js?id=" . e($trackingId) . "'></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', '" . e($trackingId) . "', {
                'anonymize_ip': true
            });
        </script>
        ";
    }
}