<?php
/** cms-core/backend/settings/api_settings.php */

/**
 * API Settings Manager
 * Verwaltet API-Schlüssel und externe Dienste
 */

class APISettings {
    
    /**
     * Holt API-Key
     */
    public static function getKey($service) {
        return get_setting($service . '_api_key', '');
    }
    
    /**
     * Setzt API-Key (verschlüsselt)
     */
    public static function setKey($service, $key) {
        // Optional: Verschlüssele API-Key vor Speicherung
        // $encrypted = DataEncryption::encrypt($key);
        return set_setting($service . '_api_key', $key, 'text');
    }
    
    /**
     * Prüft ob API-Key gesetzt ist
     */
    public static function hasKey($service) {
        $key = self::getKey($service);
        return !empty($key);
    }
    
    /**
     * Validiert API-Key (Service-spezifisch)
     */
    public static function validateKey($service, $key) {
        switch ($service) {
            case 'deepl':
                // DeepL API Key Format: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx:fx
                return preg_match('/^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}:fx$/', $key);
                
            case 'google_analytics':
                // G-XXXXXXXXXX oder UA-XXXXXXXXX-X Format
                return preg_match('/^(G-|UA-|GT-)[A-Z0-9-]+$/', $key);
                
            default:
                return !empty($key);
        }
    }
    
    /**
     * Verfügbare API-Services
     */
    public static function getServices() {
        return [
            'deepl' => [
                'name' => 'DeepL Translation',
                'description' => 'Automatische Übersetzungen',
                'key_format' => 'xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx:fx',
                'docs_url' => 'https://www.deepl.com/pro-api'
            ]
        ];
    }
}