<?php
/** cms-core/backend/settings/feature_toggles.php */

/**
 * Feature Toggles
 * Ein/Aus-Schalter für Features
 */

class FeatureToggles {
    
    /**
     * Prüft ob Feature aktiviert ist
     */
    public static function isEnabled($feature) {
        return get_setting('feature_' . $feature, false);
    }
    
    /**
     * Aktiviert Feature
     */
    public static function enable($feature) {
        return set_setting('feature_' . $feature, true, 'boolean');
    }
    
    /**
     * Deaktiviert Feature
     */
    public static function disable($feature) {
        return set_setting('feature_' . $feature, false, 'boolean');
    }
    
    /**
     * Toggle Feature
     */
    public static function toggle($feature) {
        $current = self::isEnabled($feature);
        return set_setting('feature_' . $feature, !$current, 'boolean');
    }
    
    /**
     * Verfügbare Features
     */
    public static function getAvailable() {
        return [
            'blog' => [
                'name' => 'Blog',
                'description' => 'Blog-Funktionalität aktivieren'
            ],
            'comments' => [
                'name' => 'Kommentare',
                'description' => 'Kommentarfunktion für Blog-Posts'
            ],
            'newsletter' => [
                'name' => 'Newsletter',
                'description' => 'Newsletter-Anmeldung'
            ],
            'contact_form' => [
                'name' => 'Kontaktformular',
                'description' => 'Kontaktformular auf der Website'
            ]
        ];
    }
}