<?php
/** cms-core/public/webview/404.php */

require_once __DIR__ . '/../../backend/core/init.php';

$pageTitle = '404 - Seite nicht gefunden';
$metaDescription = 'Die angeforderte Seite existiert nicht.';
$bodyClass = 'error-404';

ob_start();
?>
<section style="min-height: 80vh; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #f8f9ff 0%, #f0f4ff 100%);">
    <div class="container" style="text-align: center; max-width: 600px;">
        <div style="font-size: 8rem; font-weight: 800; background: linear-gradient(135deg, #667eea, #764ba2); -webkit-background-clip: text; -webkit-text-fill-color: transparent; margin-bottom: 1rem;">
            404
        </div>
        <h1 style="font-size: 2.5rem; margin-bottom: 1rem;">Seite nicht gefunden</h1>
        <p style="font-size: 1.25rem; color: #718096; margin-bottom: 2rem;">
            Die angeforderte Seite existiert nicht oder wurde verschoben.
        </p>
        <a href="/" style="display: inline-block; background: linear-gradient(135deg, #667eea, #764ba2); color: white; padding: 1rem 2.5rem; border-radius: 50px; text-decoration: none; font-weight: 600; transition: all 0.3s;">
            🏠 Zur Startseite
        </a>
    </div>
</section>
<?php
$pageContent = ob_get_clean();
include __DIR__ . '/includes/layout.php';