<?php
/** cms-core/public/webview/admin/api/media_list.php */

require_once __DIR__ . '/../../../../backend/authorization/check_admin.php';

header('Content-Type: application/json');

try {
    // FIXED: Use MEDIA_ROOT constant instead of hardcoded path
    $mediaDir = MEDIA_ROOT;
    
    if (!is_dir($mediaDir)) {
        // Try to create media directory if it doesn't exist
        if (!mkdir($mediaDir, 0755, true)) {
            echo json_encode([
                'success' => false, 
                'error' => 'Media-Verzeichnis existiert nicht und konnte nicht erstellt werden.'
            ]);
            exit;
        }
        
        echo json_encode(['success' => true, 'files' => []]);
        exit;
    }
    
    $files = [];
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($mediaDir, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );
    
    foreach ($iterator as $file) {
        if ($file->isFile()) {
            $extension = strtolower($file->getExtension());
            $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];
            
            if (in_array($extension, $allowedExtensions)) {
                $relativePath = str_replace($mediaDir . DIRECTORY_SEPARATOR, '', $file->getPathname());
                $relativePath = str_replace('\\', '/', $relativePath); // Windows compatibility
                
                $files[] = [
                    'name' => $file->getFilename(),
                    'path' => $relativePath,
                    'url' => '/media/' . $relativePath,  // ADDED: Full URL for frontend
                    'size' => $file->getSize(),
                    'modified' => $file->getMTime()
                ];
            }
        }
    }
    
    // Sort by modified date (newest first)
    usort($files, function($a, $b) {
        return $b['modified'] - $a['modified'];
    });
    
    echo json_encode([
        'success' => true,
        'files' => $files,
        'total' => count($files)
    ]);
    
} catch (Exception $e) {
    error_log('Media list error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => 'Fehler beim Laden der Mediathek: ' . $e->getMessage()
    ]);
}