<?php
/**
 * cms-core/public/webview/admin/components/language_switcher.php
 * Add this to your admin header/navigation
 */

// Handle language switch
if (isset($_GET['switch_lang'])) {
    $newLang = $_GET['switch_lang'];
    if (in_array($newLang, ['de', 'en'])) {
        Translation::setLanguage($newLang);
        
        // Update .env file
        $envPath = __DIR__ . '/../../../../../.env';
        if (file_exists($envPath)) {
            $envContent = file_get_contents($envPath);
            $envContent = preg_replace('/APP_LANGUAGE=\w+/', 'APP_LANGUAGE=' . $newLang, $envContent);
            file_put_contents($envPath, $envContent);
        }
        
        // Redirect to remove query param
        header('Location: ' . strtok($_SERVER['REQUEST_URI'], '?'));
        exit;
    }
}

$currentLang = current_lang();
$languages = Translation::getAvailableLanguages();
?>

<div class="language-switcher">
    <button class="lang-btn" onclick="toggleLangMenu()" title="<?= t('Sprache wechseln', 'Switch Language') ?>">
        <?= $currentLang === 'de' ? '🇩🇪' : '🇬🇧' ?>
        <span class="lang-text"><?= strtoupper($currentLang) ?></span>
    </button>
    
    <div class="lang-menu" id="langMenu">
        <?php foreach ($languages as $code => $name): ?>
            <?php if ($code !== $currentLang): ?>
                <a href="?switch_lang=<?= $code ?>" class="lang-option">
                    <?= $name ?>
                </a>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
</div>

<style>
.language-switcher {
    position: relative;
    display: inline-block;
}

.lang-btn {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 8px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 8px;
    background: white;
    cursor: pointer;
    font-size: 16px;
    transition: all 0.2s;
}

.lang-btn:hover {
    border-color: #667eea;
    background: #f9fafb;
}

.lang-text {
    font-weight: 600;
    color: #374151;
    font-size: 14px;
}

.lang-menu {
    position: absolute;
    top: 100%;
    right: 0;
    margin-top: 8px;
    background: white;
    border: 2px solid #e5e7eb;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    min-width: 150px;
    display: none;
    z-index: 1000;
}

.lang-menu.active {
    display: block;
}

.lang-option {
    display: block;
    padding: 12px 16px;
    color: #374151;
    text-decoration: none;
    transition: background 0.2s;
}

.lang-option:hover {
    background: #f0f4ff;
    color: #667eea;
}

/* Mobile */
@media (max-width: 768px) {
    .lang-btn {
        padding: 8px 12px;
    }
    
    .lang-text {
        display: none;
    }
}
</style>

<script>
function toggleLangMenu() {
    const menu = document.getElementById('langMenu');
    menu.classList.toggle('active');
}

// Close menu when clicking outside
document.addEventListener('click', function(e) {
    const switcher = document.querySelector('.language-switcher');
    if (switcher && !switcher.contains(e.target)) {
        document.getElementById('langMenu').classList.remove('active');
    }
});
</script>