<?php
/**
 * TEMPORARY DEBUG FILE
 * Upload to: cms-core/public/webview/admin/translation_debug.php
 * Access: http://yourdomain.com/admin/translation_debug.php
 */

require_once __DIR__ . '/../../../backend/core/init.php';
require_login();

// ACTION: Delete cache
if (isset($_GET['delete_cache'])) {
    $translationFile = APP_ROOT . '/cms-core/translations.json';
    if (file_exists($translationFile)) {
        unlink($translationFile);
        echo "<div style='background: #10b981; color: white; padding: 20px; margin: 20px; border-radius: 8px;'>✅ Cache gelöscht! Seite wird neu geladen...</div>";
        echo "<script>setTimeout(() => location.href = 'translation_debug.php', 1500);</script>";
        exit;
    }
}

// ACTION: Switch language
if (isset($_GET['lang'])) {
    Translation::setLanguage($_GET['lang']);
    echo "<div style='background: #10b981; color: white; padding: 20px; margin: 20px; border-radius: 8px;'>✅ Sprache auf {$_GET['lang']} gesetzt! Seite wird neu geladen...</div>";
    echo "<script>setTimeout(() => location.href = 'translation_debug.php', 1500);</script>";
    exit;
}

?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Translation System Debugger</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: #f3f4f6;
            padding: 40px;
            line-height: 1.6;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        }
        h1 {
            color: #1f2937;
            border-bottom: 3px solid #667eea;
            padding-bottom: 10px;
        }
        h2 {
            color: #374151;
            margin-top: 40px;
        }
        .info-box {
            background: #eff6ff;
            border-left: 4px solid #3b82f6;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        .warning-box {
            background: #fef2f2;
            border-left: 4px solid #ef4444;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        .success-box {
            background: #f0fdf4;
            border-left: 4px solid #10b981;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #e5e7eb;
        }
        th {
            background: #f9fafb;
            font-weight: 600;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            margin: 10px 5px;
            font-weight: 600;
            transition: all 0.2s;
        }
        .btn:hover {
            background: #5568d3;
            transform: translateY(-2px);
        }
        .btn-danger {
            background: #ef4444;
        }
        .btn-danger:hover {
            background: #dc2626;
        }
        code {
            background: #1f2937;
            color: #10b981;
            padding: 2px 8px;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
        }
        pre {
            background: #1f2937;
            color: #10b981;
            padding: 20px;
            border-radius: 8px;
            overflow-x: auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Translation System Debugger</h1>
        
        <div class="info-box">
            <strong>Aktuelle Konfiguration:</strong><br>
            Session-Sprache: <code><?= $_SESSION['language'] ?? 'nicht gesetzt' ?></code><br>
            Translation::getCurrentLang(): <code><?= Translation::getCurrentLang() ?></code><br>
            APP_LANGUAGE Konstante: <code><?= defined('APP_LANGUAGE') ? APP_LANGUAGE : 'nicht definiert' ?></code>
        </div>

        <h2>🎯 Schnellaktionen</h2>
        <a href="?delete_cache=1" class="btn btn-danger" onclick="return confirm('Cache wirklich löschen?')">🗑️ Cache löschen</a>
        <a href="?lang=de" class="btn">🇩🇪 Deutsch setzen</a>
        <a href="?lang=en" class="btn">🇬🇧 English setzen</a>

        <h2>📝 Test-Übersetzungen</h2>
        <?php
        $testStrings = [
            'Dashboard',
            'Seiten',
            'Alle Seiten',
            'Medien',
            'Media Bibliothek',
            'Design',
            'Farbe & Schrift',
            'Benutzer',
            'Benutzerverwaltung',
            'System',
            'Einstellungen',
            'Integrationen',
            'Custom-Addons',
            'Farb-Phänomen',
            'System-Update'
        ];
        ?>
        <table>
            <thead>
                <tr>
                    <th>Deutscher Text</th>
                    <th>t() Ausgabe</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($testStrings as $text): 
                    $translated = t($text);
                    $isEnglish = Translation::getCurrentLang() === 'en';
                    $isDifferent = $translated !== $text;
                    $status = ($isEnglish && $isDifferent) ? '✅' : ($isEnglish ? '❌' : '➖');
                ?>
                <tr>
                    <td><code><?= htmlspecialchars($text) ?></code></td>
                    <td><strong><?= htmlspecialchars($translated) ?></strong></td>
                    <td><?= $status ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <h2>📦 Cache-Inhalt</h2>
        <?php
        $translationFile = APP_ROOT . '/cms-core/translations.json';
        if (file_exists($translationFile)):
            $cacheContent = file_get_contents($translationFile);
            $cacheData = json_decode($cacheContent, true);
        ?>
        <div class="info-box">
            <strong>Cache-Datei existiert:</strong> <?= $translationFile ?><br>
            <strong>Einträge:</strong> <?= count($cacheData) ?><br>
            <strong>Größe:</strong> <?= number_format(filesize($translationFile) / 1024, 2) ?> KB
        </div>
        <pre><?= htmlspecialchars(json_encode($cacheData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) ?></pre>
        <?php else: ?>
        <div class="warning-box">
            ⚠️ Cache-Datei existiert nicht! Das ist OK - wird beim ersten Aufruf erstellt.
        </div>
        <?php endif; ?>

        <h2>🔧 Session-Daten</h2>
        <pre><?= htmlspecialchars(print_r($_SESSION, true)) ?></pre>

        <h2>📋 Nächste Schritte</h2>
        <div class="success-box">
            <ol>
                <li>Klicke auf "🗑️ Cache löschen"</li>
                <li>Klicke auf "🇬🇧 English setzen"</li>
                <li>Überprüfe die Test-Übersetzungen Tabelle</li>
                <li>Wenn alles ✅ ist, gehe zu <a href="dashboard.php">Dashboard</a></li>
                <li>Wenn immer noch ❌, schicke Screenshot dieser Seite!</li>
            </ol>
        </div>

        <p style="margin-top: 40px;">
            <a href="dashboard.php" class="btn">← Zurück zum Dashboard</a>
        </p>
    </div>
</body>
</html>