<?php
/**
 * cms-core/public/webview/admin/farb_font.php
 * COMPLETE: Farb- und Schrifteinstellungen mit Header & Footer Controls
 */

require_once __DIR__ . '/../../../backend/authorization/check_admin.php';

// Handle Form Submit
if (is_post()) {
    try {
        CSRF::require();
        $action = post('action');

        if ($action === 'save_styles') {
            error_log("=== SAVING STYLES ===");
            
            $styles = [
                // H1
                'h1_color' => trim(post('h1_color')),
                'h1_font' => trim(post('h1_font')),
                'h1_weight' => trim(post('h1_weight')),
                // H2
                'h2_color' => trim(post('h2_color')),
                'h2_font' => trim(post('h2_font')),
                'h2_weight' => trim(post('h2_weight')),
                // H3
                'h3_color' => trim(post('h3_color')),
                'h3_font' => trim(post('h3_font')),
                'h3_weight' => trim(post('h3_weight')),
                // Text
                'text_color' => trim(post('text_color')),
                'text_font' => trim(post('text_font')),
                'text_weight' => trim(post('text_weight')),
                // Content Links
                'link_color' => trim(post('link_color')),
                'link_hover_color' => trim(post('link_hover_color')),
                // Button
                'button_bg_color' => trim(post('button_bg_color')),
                'button_text_color' => trim(post('button_text_color')),
                'button_font' => trim(post('button_font')),
                'button_weight' => trim(post('button_weight')),
                // Body/Section Backgrounds
                'body_bg_color' => trim(post('body_bg_color')),
                'section_bg_color' => trim(post('section_bg_color')),
                // Header
                'header_bg_color' => trim(post('header_bg_color')),
                'header_text_color' => trim(post('header_text_color')),
                'header_heading_color' => trim(post('header_heading_color')),
                'header_link_color' => trim(post('header_link_color')),
                'header_link_hover_color' => trim(post('header_link_hover_color')),
                // Footer
                'footer_bg_color' => trim(post('footer_bg_color')),
                'footer_text_color' => trim(post('footer_text_color')),
                'footer_heading_color' => trim(post('footer_heading_color')),
                'footer_link_color' => trim(post('footer_link_color')),
                'footer_link_hover_color' => trim(post('footer_link_hover_color')),
            ];
            
            FarbFont::saveMultipleStyles($styles);
            
            set_flash('success', 'Farb- und Schrifteinstellungen erfolgreich gespeichert!');
            redirect('/admin/farb_font');
            exit();
        }

        if ($action === 'reset_defaults') {
            FarbFont::resetToDefaults();
            set_flash('success', 'Einstellungen auf Standard zurückgesetzt.');
            redirect('/admin/farb_font');
            exit();
        }

    } catch (Exception $e) {
        error_log("ERROR in farb_font.php: " . $e->getMessage());
        set_flash('error', 'Fehler: ' . $e->getMessage());
        redirect('/admin/farb_font');
        exit();
    }
}

$currentStyles = FarbFont::getAllStyles();
$fontFamilies = FarbFont::FONT_FAMILIES;
$fontWeights = FarbFont::FONT_WEIGHTS;
$flashMessages = get_flash();
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Farbe & Schrift</title>
    <?php
$adminCssPath = APP_ROOT . '/assets/css/admin.css';
$adminCssVersion = file_exists($adminCssPath) ? filemtime($adminCssPath) : time();
?>
<link rel="stylesheet" href="/assets/css/admin.css?v=<?= $adminCssVersion ?>">
<style>
    .settings-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 30px;
    }
    @media (max-width: 1200px) {
        .settings-grid { grid-template-columns: 1fr; }
    }
    .settings-section {
        margin-bottom: 30px;
        padding: 24px;
        background: #f9fafb;
        border-radius: 12px;
        border: 1px solid #e5e7eb;
    }
    .settings-section h3 {
        margin: 0 0 20px 0;
        color: #1f2937;
        font-size: 18px;
        font-weight: 600;
    }
    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 16px;
        margin-bottom: 16px;
    }
    .preview-box {
        position: sticky;
        top: 20px;
        padding: 0;
        background: white;
        border: 2px solid #e5e7eb;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        overflow: hidden;
    }
    .form-input-color {
        width: 100%;
        height: 50px;
        border: 2px solid #e5e7eb;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.2s;
    }
    .form-input-color:hover {
        border-color: #667eea;
        transform: scale(1.02);
    }
    .color-value {
        text-align: center;
        font-size: 11px;
        color: #6b7280;
        margin-top: 4px;
        font-family: 'Courier New', monospace;
    }
    .form-hint {
        font-size: 12px;
        color: #6b7280;
        margin-top: 8px;
        display: block;
    }
    </style>
</head>
<body>
    <?php include __DIR__ . '/includes/admin_header.php'; ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/includes/admin_sidebar.php'; ?>
        
        <main class="admin-content">
            <?php foreach ($flashMessages as $flash): ?>
                <div class="alert alert-<?= e($flash['type']) ?>">
                    <?= e($flash['message']) ?>
                </div>
            <?php endforeach; ?>
            
            <div class="page-header">
                <div>
                    <h1>🎨 Farbe & Schrift</h1>
                    <p class="page-description">Globale Farb- und Schrifteinstellungen</p>
                </div>
            </div>

            <form method="POST" action="/admin/farb_font" id="styles-form">
                <?= CSRF::field() ?>
                <input type="hidden" name="action" value="save_styles">
                
                <div class="settings-grid">
                    <!-- LEFT: Settings -->
                    <div>
                        <div class="content-card">
                            
                            <!-- H1 Settings -->
                            <div class="settings-section">
                                <h3>📝 H1 Überschriften</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label class="form-label">Farbe</label>
                                        <input type="color" name="h1_color" id="h1_color"
                                            value="<?= e($currentStyles['h1_color'] ?? '#667eea') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="h1_color_value"><?= e($currentStyles['h1_color'] ?? '#667eea') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftart</label>
                                        <select name="h1_font" id="h1_font" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontFamilies as $name => $family): ?>
                                                <option value="<?= e($name) ?>" <?= ($currentStyles['h1_font'] ?? 'Arial') === $name ? 'selected' : '' ?>>
                                                    <?= e($name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftstärke</label>
                                        <select name="h1_weight" id="h1_weight" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontWeights as $value => $label): ?>
                                                <option value="<?= e($value) ?>" <?= ($currentStyles['h1_weight'] ?? '700') == $value ? 'selected' : '' ?>>
                                                    <?= e($label) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- H2 Settings -->
                            <div class="settings-section">
                                <h3>📝 H2 Überschriften</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label class="form-label">Farbe</label>
                                        <input type="color" name="h2_color" id="h2_color"
                                            value="<?= e($currentStyles['h2_color'] ?? '#4a5568') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="h2_color_value"><?= e($currentStyles['h2_color'] ?? '#4a5568') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftart</label>
                                        <select name="h2_font" id="h2_font" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontFamilies as $name => $family): ?>
                                                <option value="<?= e($name) ?>" <?= ($currentStyles['h2_font'] ?? 'Arial') === $name ? 'selected' : '' ?>>
                                                    <?= e($name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftstärke</label>
                                        <select name="h2_weight" id="h2_weight" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontWeights as $value => $label): ?>
                                                <option value="<?= e($value) ?>" <?= ($currentStyles['h2_weight'] ?? '600') == $value ? 'selected' : '' ?>>
                                                    <?= e($label) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- H3 Settings -->
                            <div class="settings-section">
                                <h3>📝 H3 Überschriften</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label class="form-label">Farbe</label>
                                        <input type="color" name="h3_color" id="h3_color"
                                            value="<?= e($currentStyles['h3_color'] ?? '#2d3748') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="h3_color_value"><?= e($currentStyles['h3_color'] ?? '#2d3748') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftart</label>
                                        <select name="h3_font" id="h3_font" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontFamilies as $name => $family): ?>
                                                <option value="<?= e($name) ?>" <?= ($currentStyles['h3_font'] ?? 'Arial') === $name ? 'selected' : '' ?>>
                                                    <?= e($name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftstärke</label>
                                        <select name="h3_weight" id="h3_weight" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontWeights as $value => $label): ?>
                                                <option value="<?= e($value) ?>" <?= ($currentStyles['h3_weight'] ?? '600') == $value ? 'selected' : '' ?>>
                                                    <?= e($label) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Text Settings -->
                            <div class="settings-section">
                                <h3>📄 Fließtext</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label class="form-label">Farbe</label>
                                        <input type="color" name="text_color" id="text_color"
                                            value="<?= e($currentStyles['text_color'] ?? '#2d3748') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="text_color_value"><?= e($currentStyles['text_color'] ?? '#2d3748') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftart</label>
                                        <select name="text_font" id="text_font" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontFamilies as $name => $family): ?>
                                                <option value="<?= e($name) ?>" <?= ($currentStyles['text_font'] ?? 'Arial') === $name ? 'selected' : '' ?>>
                                                    <?= e($name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftstärke</label>
                                        <select name="text_weight" id="text_weight" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontWeights as $value => $label): ?>
                                                <option value="<?= e($value) ?>" <?= ($currentStyles['text_weight'] ?? '400') == $value ? 'selected' : '' ?>>
                                                    <?= e($label) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Content Links -->
                            <div class="settings-section">
                                <h3>🔗 Text Links (Inhalt)</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label class="form-label">Link-Farbe</label>
                                        <input type="color" name="link_color" id="link_color"
                                            value="<?= e($currentStyles['link_color'] ?? '#667eea') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="link_color_value"><?= e($currentStyles['link_color'] ?? '#667eea') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Hover-Farbe</label>
                                        <input type="color" name="link_hover_color" id="link_hover_color"
                                            value="<?= e($currentStyles['link_hover_color'] ?? '#5a67d8') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="link_hover_color_value"><?= e($currentStyles['link_hover_color'] ?? '#5a67d8') ?></div>
                                    </div>
                                </div>
                                <small class="form-hint">💡 Für Links im Fließtext und Rechtliche Seiten</small>
                            </div>
                            
                            <!-- Buttons -->
                            <div class="settings-section">
                                <h3>🔘 Buttons</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label class="form-label">Hintergrund</label>
                                        <input type="color" name="button_bg_color" id="button_bg_color"
                                            value="<?= e($currentStyles['button_bg_color'] ?? '#667eea') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="button_bg_color_value"><?= e($currentStyles['button_bg_color'] ?? '#667eea') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Textfarbe</label>
                                        <input type="color" name="button_text_color" id="button_text_color"
                                            value="<?= e($currentStyles['button_text_color'] ?? '#ffffff') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="button_text_color_value"><?= e($currentStyles['button_text_color'] ?? '#ffffff') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftart</label>
                                        <select name="button_font" id="button_font" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontFamilies as $name => $family): ?>
                                                <option value="<?= e($name) ?>" <?= ($currentStyles['button_font'] ?? 'Arial') === $name ? 'selected' : '' ?>>
                                                    <?= e($name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Schriftstärke</label>
                                        <select name="button_weight" id="button_weight" class="form-input" onchange="updatePreview()">
                                            <?php foreach ($fontWeights as $value => $label): ?>
                                                <option value="<?= e($value) ?>" <?= ($currentStyles['button_weight'] ?? '600') == $value ? 'selected' : '' ?>>
                                                    <?= e($label) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Body/Section Backgrounds -->
                            <div class="settings-section">
                                <h3>🎨 Body & Section Hintergründe</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label class="form-label">Body Hintergrund</label>
                                        <input type="color" name="body_bg_color" id="body_bg_color"
                                            value="<?= e($currentStyles['body_bg_color'] ?? '#ffffff') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="body_bg_color_value"><?= e($currentStyles['body_bg_color'] ?? '#ffffff') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Section Hintergrund</label>
                                        <input type="color" name="section_bg_color" id="section_bg_color"
                                            value="<?= e($currentStyles['section_bg_color'] ?? '#f7fafc') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="section_bg_color_value"><?= e($currentStyles['section_bg_color'] ?? '#f7fafc') ?></div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- HEADER -->
                            <div class="settings-section" style="background: #eff6ff; border-color: #3b82f6;">
                                <h3>🎯 Header / Navigation</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label class="form-label">Hintergrund</label>
                                        <input type="color" name="header_bg_color" id="header_bg_color"
                                            value="<?= e($currentStyles['header_bg_color'] ?? '#ffffff') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="header_bg_color_value"><?= e($currentStyles['header_bg_color'] ?? '#ffffff') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Text</label>
                                        <input type="color" name="header_text_color" id="header_text_color"
                                            value="<?= e($currentStyles['header_text_color'] ?? '#2d3748') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="header_text_color_value"><?= e($currentStyles['header_text_color'] ?? '#2d3748') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Logo/Überschrift</label>
                                        <input type="color" name="header_heading_color" id="header_heading_color"
                                            value="<?= e($currentStyles['header_heading_color'] ?? '#1f2937') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="header_heading_color_value"><?= e($currentStyles['header_heading_color'] ?? '#1f2937') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Menu Links</label>
                                        <input type="color" name="header_link_color" id="header_link_color"
                                            value="<?= e($currentStyles['header_link_color'] ?? '#4b5563') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="header_link_color_value"><?= e($currentStyles['header_link_color'] ?? '#4b5563') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Menu Hover/Active</label>
                                        <input type="color" name="header_link_hover_color" id="header_link_hover_color"
                                            value="<?= e($currentStyles['header_link_hover_color'] ?? '#667eea') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="header_link_hover_color_value"><?= e($currentStyles['header_link_hover_color'] ?? '#667eea') ?></div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- FOOTER -->
                            <div class="settings-section" style="background: #f3f4f6; border-color: #6b7280;">
                                <h3>🦶 Footer</h3>
                                <div class="form-row">
                                    <div class="form-group">
                                        <label class="form-label">Hintergrund</label>
                                        <input type="color" name="footer_bg_color" id="footer_bg_color"
                                            value="<?= e($currentStyles['footer_bg_color'] ?? '#1a202c') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="footer_bg_color_value"><?= e($currentStyles['footer_bg_color'] ?? '#1a202c') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Text</label>
                                        <input type="color" name="footer_text_color" id="footer_text_color"
                                            value="<?= e($currentStyles['footer_text_color'] ?? '#ffffff') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="footer_text_color_value"><?= e($currentStyles['footer_text_color'] ?? '#ffffff') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Überschriften</label>
                                        <input type="color" name="footer_heading_color" id="footer_heading_color"
                                            value="<?= e($currentStyles['footer_heading_color'] ?? '#ffffff') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="footer_heading_color_value"><?= e($currentStyles['footer_heading_color'] ?? '#ffffff') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Links</label>
                                        <input type="color" name="footer_link_color" id="footer_link_color"
                                            value="<?= e($currentStyles['footer_link_color'] ?? '#d1d5db') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="footer_link_color_value"><?= e($currentStyles['footer_link_color'] ?? '#d1d5db') ?></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Links Hover</label>
                                        <input type="color" name="footer_link_hover_color" id="footer_link_hover_color"
                                            value="<?= e($currentStyles['footer_link_hover_color'] ?? '#ffffff') ?>" 
                                            class="form-input-color" onchange="updatePreview()">
                                        <div class="color-value" id="footer_link_hover_color_value"><?= e($currentStyles['footer_link_hover_color'] ?? '#ffffff') ?></div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="form-actions" style="margin-top: 20px;">
                            <button type="button" class="btn btn-secondary" onclick="if(confirm('Wirklich auf Standard zurücksetzen?')) { document.querySelector('[name=action]').value='reset_defaults'; document.getElementById('styles-form').submit(); }">
                                🔄 Standard wiederherstellen
                            </button>
                            <button type="submit" class="btn btn-primary">💾 Speichern</button>
                        </div>
                    </div>
                    
                    <!-- RIGHT: Live Preview -->
                    <div>
                        <div class="content-card">
                            <h3 style="margin-bottom: 20px;">👁️ Live Vorschau</h3>
                            <div class="preview-box" id="preview">
                                <!-- Header Preview -->
                                <div id="header-preview" style="padding: 20px; border-bottom: 1px solid #e5e7eb;">
                                    <div style="display: flex; justify-content: space-between; align-items: center;">
                                        <div id="header-logo" style="font-weight: 700; font-size: 18px;">Logo / Sitename</div>
                                        <div style="display: flex; gap: 15px;">
                                            <a href="#" id="header-link-1" style="text-decoration: none; font-size: 14px;">Home</a>
                                            <a href="#" id="header-link-2" style="text-decoration: none; font-size: 14px;">Über uns</a>
                                            <a href="#" id="header-link-3" style="text-decoration: none; font-size: 14px;">Kontakt</a>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Content Preview -->
                                <div style="padding: 30px;">
                                    <h1 id="preview-h1" style="margin-bottom: 16px;">Hauptüberschrift H1</h1>
                                    <h2 id="preview-h2" style="margin-bottom: 12px;">Unterüberschrift H2</h2>
                                    <h3 id="preview-h3" style="margin-bottom: 10px;">Weitere Überschrift H3</h3>
                                    <p id="preview-text" style="margin-bottom: 16px; line-height: 1.6;">
                                        Dies ist ein Beispieltext mit 
                                        <a href="#" id="preview-link" style="text-decoration: underline;">einem Link im Text</a>.
                                    </p>
                                    <button id="preview-button" style="padding: 12px 24px; border-radius: 8px; border: none; cursor: pointer;">Beispiel Button</button>
                                </div>
                                
                                <!-- Footer Preview -->
                                <div id="footer-preview" style="padding: 20px; border-top: 1px solid #e5e7eb;">
                                    <h4 id="footer-heading" style="margin-bottom: 10px; font-size: 16px;">Footer Überschrift</h4>
                                    <p id="footer-text" style="margin: 10px 0; font-size: 14px;">Footer Text Beispiel</p>
                                    <div style="display: flex; gap: 15px; margin-top: 10px;">
                                        <a href="#" id="footer-link-1" style="text-decoration: none; font-size: 14px;">Impressum</a>
                                        <a href="#" id="footer-link-2" style="text-decoration: none; font-size: 14px;">Datenschutz</a>
                                        <a href="#" id="footer-link-3" style="text-decoration: none; font-size: 14px;">Kontakt</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </main>
    </div>
    
    <script>
    function updatePreview() {
        const fontMap = <?= json_encode($fontFamilies) ?>;
        const getFont = (name) => fontMap[name] || 'Arial, sans-serif';
        
        // H1
        const h1 = document.getElementById('preview-h1');
        h1.style.color = document.getElementById('h1_color').value;
        h1.style.fontFamily = getFont(document.getElementById('h1_font').value);
        h1.style.fontWeight = document.getElementById('h1_weight').value;
        document.getElementById('h1_color_value').textContent = document.getElementById('h1_color').value;
        
        // H2
        const h2 = document.getElementById('preview-h2');
        h2.style.color = document.getElementById('h2_color').value;
        h2.style.fontFamily = getFont(document.getElementById('h2_font').value);
        h2.style.fontWeight = document.getElementById('h2_weight').value;
        document.getElementById('h2_color_value').textContent = document.getElementById('h2_color').value;
        
        // H3
        const h3 = document.getElementById('preview-h3');
        h3.style.color = document.getElementById('h3_color').value;
        h3.style.fontFamily = getFont(document.getElementById('h3_font').value);
        h3.style.fontWeight = document.getElementById('h3_weight').value;
        document.getElementById('h3_color_value').textContent = document.getElementById('h3_color').value;
        
        // Text
        const text = document.getElementById('preview-text');
        text.style.color = document.getElementById('text_color').value;
        text.style.fontFamily = getFont(document.getElementById('text_font').value);
        text.style.fontWeight = document.getElementById('text_weight').value;
        document.getElementById('text_color_value').textContent = document.getElementById('text_color').value;
        
        // Content Link
        const link = document.getElementById('preview-link');
        link.style.color = document.getElementById('link_color').value;
        link.onmouseover = () => link.style.color = document.getElementById('link_hover_color').value;
        link.onmouseout = () => link.style.color = document.getElementById('link_color').value;
        document.getElementById('link_color_value').textContent = document.getElementById('link_color').value;
        document.getElementById('link_hover_color_value').textContent = document.getElementById('link_hover_color').value;
        
        // Button
        const button = document.getElementById('preview-button');
        button.style.backgroundColor = document.getElementById('button_bg_color').value;
        button.style.color = document.getElementById('button_text_color').value;
        button.style.fontFamily = getFont(document.getElementById('button_font').value);
        button.style.fontWeight = document.getElementById('button_weight').value;
        document.getElementById('button_bg_color_value').textContent = document.getElementById('button_bg_color').value;
        document.getElementById('button_text_color_value').textContent = document.getElementById('button_text_color').value;
        
        // Body/Section
        const preview = document.getElementById('preview');
        document.getElementById('body_bg_color_value').textContent = document.getElementById('body_bg_color').value;
        document.getElementById('section_bg_color_value').textContent = document.getElementById('section_bg_color').value;
        
        // Header
        const headerPreview = document.getElementById('header-preview');
        headerPreview.style.backgroundColor = document.getElementById('header_bg_color').value;
        headerPreview.style.color = document.getElementById('header_text_color').value;
        document.getElementById('header_bg_color_value').textContent = document.getElementById('header_bg_color').value;
        document.getElementById('header_text_color_value').textContent = document.getElementById('header_text_color').value;
        
        const headerLogo = document.getElementById('header-logo');
        headerLogo.style.color = document.getElementById('header_heading_color').value;
        document.getElementById('header_heading_color_value').textContent = document.getElementById('header_heading_color').value;
        
        const headerLinks = [document.getElementById('header-link-1'), document.getElementById('header-link-2'), document.getElementById('header-link-3')];
        const headerLinkColor = document.getElementById('header_link_color').value;
        const headerLinkHover = document.getElementById('header_link_hover_color').value;
        headerLinks.forEach(link => {
            link.style.color = headerLinkColor;
            link.onmouseover = () => link.style.color = headerLinkHover;
            link.onmouseout = () => link.style.color = headerLinkColor;
        });
        document.getElementById('header_link_color_value').textContent = headerLinkColor;
        document.getElementById('header_link_hover_color_value').textContent = headerLinkHover;
        
        // Footer
        const footerPreview = document.getElementById('footer-preview');
        footerPreview.style.backgroundColor = document.getElementById('footer_bg_color').value;
        document.getElementById('footer_bg_color_value').textContent = document.getElementById('footer_bg_color').value;
        
        const footerText = document.getElementById('footer-text');
        footerText.style.color = document.getElementById('footer_text_color').value;
        document.getElementById('footer_text_color_value').textContent = document.getElementById('footer_text_color').value;
        
        const footerHeading = document.getElementById('footer-heading');
        footerHeading.style.color = document.getElementById('footer_heading_color').value;
        document.getElementById('footer_heading_color_value').textContent = document.getElementById('footer_heading_color').value;
        
        const footerLinks = [document.getElementById('footer-link-1'), document.getElementById('footer-link-2'), document.getElementById('footer-link-3')];
        const footerLinkColor = document.getElementById('footer_link_color').value;
        const footerLinkHover = document.getElementById('footer_link_hover_color').value;
        footerLinks.forEach(link => {
            link.style.color = footerLinkColor;
            link.onmouseover = () => link.style.color = footerLinkHover;
            link.onmouseout = () => link.style.color = footerLinkColor;
        });
        document.getElementById('footer_link_color_value').textContent = footerLinkColor;
        document.getElementById('footer_link_hover_color_value').textContent = footerLinkHover;
    }
    
    document.addEventListener('DOMContentLoaded', updatePreview);
    </script>
    <!-- CRITICAL: Add main.js for mobile menu functionality -->
    <script src="/assets/js/main.js"></script>
</body>
</html>