<?php
/**
 * basic-debug.php
 * Upload to /admin/ - Finds what's breaking
 */

// Force error display
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

// Start output buffering to catch any errors
ob_start();

echo "<!DOCTYPE html><html><head><meta charset='UTF-8'></head><body>";
echo "<pre style='background:#000;color:#0f0;padding:20px;font-family:monospace;font-size:14px;'>";
echo "=== BASIC DEBUG ===\n\n";

try {
    echo "Step 1: PHP is working... ✓\n";
    echo "PHP Version: " . PHP_VERSION . "\n\n";
    
    echo "Step 2: Loading init.php...\n";
    flush();
    
    $initPath = __DIR__ . '/../../../backend/core/init.php';
    echo "Path: $initPath\n";
    echo "Exists: " . (file_exists($initPath) ? 'YES' : 'NO') . "\n";
    
    if (!file_exists($initPath)) {
        throw new Exception("init.php not found!");
    }
    
    require_once $initPath;
    echo "✓ init.php loaded\n\n";
    
    echo "Step 3: Checking session...\n";
    echo "Session ID: " . session_id() . "\n";
    echo "User ID: " . ($_SESSION['user_id'] ?? 'NOT SET') . "\n\n";
    
    echo "Step 4: Loading check_admin.php...\n";
    flush();
    
    $checkAdminPath = __DIR__ . '/../../../backend/authorization/check_admin.php';
    echo "Path: $checkAdminPath\n";
    echo "Exists: " . (file_exists($checkAdminPath) ? 'YES' : 'NO') . "\n";
    
    if (!file_exists($checkAdminPath)) {
        throw new Exception("check_admin.php not found!");
    }
    
    require_once $checkAdminPath;
    echo "✓ check_admin.php loaded\n\n";
    
    echo "Step 5: Testing functions...\n";
    echo "current_user exists: " . (function_exists('current_user') ? 'YES' : 'NO') . "\n";
    echo "can exists: " . (function_exists('can') ? 'YES' : 'NO') . "\n";
    echo "is_admin exists: " . (function_exists('is_admin') ? 'YES' : 'NO') . "\n\n";
    
    if (function_exists('current_user')) {
        $user = current_user();
        echo "Current user: " . $user['username'] . "\n";
        echo "Role: " . $user['role'] . "\n\n";
    }
    
    echo "Step 6: Checking UserRoles class...\n";
    echo "UserRoles exists: " . (class_exists('UserRoles') ? 'YES' : 'NO') . "\n\n";
    
    echo "=== ALL BASIC TESTS PASSED ===\n\n";
    echo "If you see this, the basic loading works.\n";
    echo "The white screen must be in the page HTML/layout.\n\n";
    
    echo "Try accessing:\n";
    echo "- dashboard.php (should work)\n";
    echo "- user_manage.php (white screen?)\n";
    echo "- media_manage.php (white screen?)\n\n";
    
    echo "Next: Check browser console for JavaScript errors\n";
    echo "or view page source to see if there's partial HTML.\n";
    
} catch (Throwable $e) {
    echo "\n\n!!! ERROR FOUND !!!\n\n";
    echo "Type: " . get_class($e) . "\n";
    echo "Message: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n\n";
    echo "Stack Trace:\n";
    echo $e->getTraceAsString() . "\n";
}

echo "</pre>";

// Check if output buffer has content
$output = ob_get_clean();
if (empty(trim(strip_tags($output)))) {
    echo "OUTPUT BUFFER WAS EMPTY!";
}

echo $output;
echo "</body></html>";
?>