<?php
/** 
 * cms-core/public/webview/admin/includes/admin_sidebar.php
 * ✅ 100% TRANSLATED - Every single text uses t()
 */

$currentPage = basename($_SERVER['PHP_SELF'], '.php');

function isActive($page) {
    global $currentPage;
    return $currentPage === $page ? 'active' : '';
}
?>

<?php if (get_setting('maintenance_mode', false)): ?>
<div style="position: fixed; top: 70px; left: 0; right: 0; background: #f59e0b; color: white; padding: 12px 20px; z-index: 9999; text-align: center; box-shadow: 0 2px 10px rgba(0,0,0,0.2);">
    <div style="display: flex; align-items: center; justify-content: center; gap: 15px; flex-wrap: wrap;">
        <span style="font-size: 20px;">🔧</span>
        <strong><?= t('WARTUNGSMODUS AKTIV') ?></strong>
        <span style="opacity: 0.9;">|</span>
        <span style="font-size: 14px;"><?= t('Die Website ist für Besucher nicht erreichbar.') ?></span>
        <span style="opacity: 0.9;">|</span>
        <a href="settings.php" style="color: white; text-decoration: underline; font-weight: 600;">
            <?= t('Deaktivieren') ?> →
        </a>
    </div>
</div>
<div style="height: 50px;"></div>
<?php endif; ?>

<aside class="admin-sidebar">
    <nav class="sidebar-nav">
        <a href="/admin/dashboard.php" class="nav-item <?= isActive('dashboard') ?>">
            <span class="nav-icon">📊</span>
            <span class="nav-text"><?= t('Dashboard') ?></span>
        </a>
        
        <div class="nav-group">
            <div class="nav-group-title"><?= t('Seiten') ?></div>
            <a href="/admin/page_manage.php" class="nav-item <?= isActive('page_manage') ?> <?= isActive('page_create_edit') ?>">
                <span class="nav-icon">📄</span>
                <span class="nav-text"><?= t('Alle Seiten') ?></span>
            </a>
        </div>
        
        <?php 
        // Only show Blog section if enabled
        $blogEnabled = get_setting('blog_enabled', false);
        if ($blogEnabled): 
        ?>
        <div class="nav-group">
            <div class="nav-group-title"><?= t('Blog') ?></div>
            <a href="/admin/blog_manage.php" class="nav-item <?= isActive('blog_manage') ?>">
                <span class="nav-icon">📝</span>
                <span class="nav-text"><?= t('Alle Posts') ?></span>
            </a>
        </div>
        <?php endif; ?>
        
        <div class="nav-group">
            <div class="nav-group-title"><?= t('Medien') ?></div>
            <a href="/admin/media_manage.php" class="nav-item <?= isActive('media_manage') ?>">
                <span class="nav-icon">📁</span>
                <span class="nav-text"><?= t('Media Bibliothek') ?></span>
            </a>
        </div>
        
        <div class="nav-group">
            <div class="nav-group-title"><?= t('Design') ?></div>
            <a href="/admin/farb_font.php" class="nav-item <?= isActive('farb_font') ?>">
                <span class="nav-icon">🎨</span>
                <span class="nav-text"><?= t('Farbe & Schrift') ?></span>
            </a>
        </div>

        <!-- User Management (Super Admin + Admin only) -->
        <?php if (function_exists('can') && can('users.manage')): ?>
        <div class="nav-group">
            <div class="nav-group-title"><?= t('Benutzer') ?></div>
            <a href="/admin/user_manage.php" class="nav-item <?= isActive('user_manage') ?>">
                <span class="nav-icon">👥</span>
                <span class="nav-text"><?= t('Benutzerverwaltung') ?></span>
            </a>
        </div>
        <?php endif; ?>

        <?php
        // CUSTOM ADMIN PAGES: Load from registration file
        $customAdminPages = [];
        $projectRoot = realpath(__DIR__ . '/../../../../../');
        $registrationFile = $projectRoot . '/customizations/admin-pages/_register.php';

        if (file_exists($registrationFile)) {
            $customAdminPages = require $registrationFile;
            
            if (!empty($customAdminPages) && is_array($customAdminPages)) {
                usort($customAdminPages, function($a, $b) {
                    return ($a['order'] ?? 999) <=> ($b['order'] ?? 999);
                });
            }
        }
        ?>        
        
        <?php if (!empty($customAdminPages)): ?>
            <div class="nav-group">
                <div class="nav-group-title"><?= t('Custom-Addons') ?></div>
                <?php foreach ($customAdminPages as $page): ?>
                    <a href="/customizations/admin-pages/<?= e($page['file']) ?>" 
                       class="nav-item <?= (basename($_SERVER['PHP_SELF']) == $page['file']) ? 'active' : '' ?>">
                        <span class="nav-icon"><?= $page['icon'] ?? '📄' ?></span>
                        <span class="nav-text"><?= t($page['title']) ?></span>
                    </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>         
        
        <div class="nav-group">
            <div class="nav-group-title"><?= t('System') ?></div>
            <a href="/admin/settings.php" class="nav-item <?= isActive('settings') ?>">
                <span class="nav-icon">⚙️</span>
                <span class="nav-text"><?= t('Einstellungen') ?></span>
            </a>
            <a href="/admin/integrations.php" class="nav-item <?= isActive('integrations') ?>">
                <span class="nav-icon">🔌</span>
                <span class="nav-text"><?= t('Integrationen') ?></span>
            </a>
            <a href="/admin/sitemap_manage.php" class="nav-item <?= isActive('sitemap_manage') ?>">
                <span class="nav-icon">🗺️</span>
                <span class="nav-text"><?= t('Sitemap') ?></span>
            </a>
            <a href="/admin/robots_manage.php" class="nav-item <?= isActive('robots_manage') ?>">
                <span class="nav-icon">🤖</span>
                <span class="nav-text">robots.txt</span>
            </a>
            <a href="/admin/error_logs.php" class="nav-item <?= isActive('error_logs') ?>">
                <span class="nav-icon">🔍</span>
                <span class="nav-text">Error Logs</span>
            </a>
        </div>  

        <div style="position: absolute; bottom: 20px; left: 20px; right: 20px;">
            <a href="cms_core_updater.php" style="display: block; padding: 8px; text-align: center; color: #9ca3af; font-size: 12px; text-decoration: none; border-radius: 6px; transition: all 0.2s;" onmouseover="this.style.background='#f3f4f6'; this.style.color='#667eea'" onmouseout="this.style.background='transparent'; this.style.color='#9ca3af'">
                🔧 <?= t('System-Update') ?>
            </a>
        </div>         
    </nav>
</aside>