<?php
/** 
 * cms-core/public/webview/admin/includes/block_editor.php
 * FINAL: RichText fix + icon_or_image with Remove button + FIXED IMAGE PATHS
 */

// Variables available: $block, $availableBlockTypes

$blockType = $availableBlockTypes[$block['block_type_template']] ?? null;
if (!$blockType) return;

$blockId = $block['id'];

// Decode JSON from block_data column
$data = [];
if (!empty($block['block_data'])) {
    $data = json_decode($block['block_data'], true) ?? [];
}
// Fallback to block_value if block_data is empty
if (empty($data) && !empty($block['block_value'])) {
    $data = json_decode($block['block_value'], true) ?? [];
}

// Load RichTextField once at the top
require_once __DIR__ . '/../../../../backend/core/RichTextField.php';
?>

<div class="block-editor" data-block-id="<?= $blockId ?>" draggable="true">
    <div class="block-header">
        <div class="block-title">
            <span class="drag-handle" title="Ziehen zum Sortieren">⋮⋮</span>
            <span><?= $blockType['icon'] ?> <?= e($blockType['name']) ?></span>
        </div>
        <div class="block-actions">
            <button type="button" class="block-action-btn" onclick="toggleBlock(<?= $blockId ?>)" title="Ein-/Ausklappen">
                <span id="toggle-icon-<?= $blockId ?>">▼</span>
            </button>
            <button type="button" class="block-action-btn danger" onclick="deleteBlock(<?= $blockId ?>)" title="Löschen">
                🗑️
            </button>
        </div>
    </div>
    
    <div id="block-content-<?= $blockId ?>" class="block-content">
        <?php foreach ($blockType['fields'] as $fieldKey => $field): ?>
            <?php 
            $fieldName = "block_data[{$blockId}][{$fieldKey}]";
            $fieldId = "block_{$blockId}_{$fieldKey}";
            $fieldValue = $data[$fieldKey] ?? ($field['default'] ?? '');
            ?>
            
            <?php if ($field['type'] === 'repeater'): ?>
                <!-- Repeater Field -->
                <div class="form-group">
                    <label class="form-label"><?= e($field['label']) ?></label>
                    
                    <div id="repeater-<?= $blockId ?>-<?= $fieldKey ?>" class="repeater-container">
                        <?php 
                        $items = is_array($fieldValue) ? $fieldValue : [];
                        
                        if (empty($items)) {
                            $items = [[]];
                        }
                        
                        foreach ($items as $index => $item): 
                        ?>
                            <div class="repeater-item">
                                <div class="repeater-item-header">
                                    <strong><?= e($field['item_label'] ?? 'Element') ?> #<?= $index + 1 ?></strong>
                                    <button type="button" 
                                            class="block-action-btn danger" 
                                            onclick="removeRepeaterItem(this)" 
                                            title="Entfernen">
                                        🗑️
                                    </button>
                                </div>
                                
                                <div class="repeater-item-content">
                                    <?php foreach ($field['fields'] as $subFieldKey => $subField): ?>
                                        <?php 
                                        $subFieldName = "block_data[{$blockId}][{$fieldKey}][{$index}][{$subFieldKey}]";
                                        $subFieldId = "block_{$blockId}_{$fieldKey}_{$index}_{$subFieldKey}";
                                        $subFieldValue = $item[$subFieldKey] ?? ($subField['default'] ?? '');
                                        ?>
                                        
                                        <?php if ($subField['type'] === 'richtext'): ?>
                                            <!-- Rich Text Field in Repeater -->
                                            <?php 
                                            // CRITICAL: Properly parse richtext data
                                            $richFieldValue = ['text' => ''];
                                            
                                            if (is_string($subFieldValue)) {
                                                // Try to decode if it's JSON
                                                $decoded = @json_decode($subFieldValue, true);
                                                if (is_array($decoded) && isset($decoded['text'])) {
                                                    $richFieldValue = $decoded;
                                                } else {
                                                    // Plain string
                                                    $richFieldValue = ['text' => $subFieldValue];
                                                }
                                            } elseif (is_array($subFieldValue)) {
                                                $richFieldValue = $subFieldValue;
                                            }
                                            
                                            echo RichTextField::render(
                                                $subFieldId,
                                                $subFieldName,
                                                $richFieldValue,
                                                $subField['label'],
                                                $subField['required'] ?? false
                                            );
                                            ?>
                                        
                                        <?php elseif ($subField['type'] === 'icon_or_image'): ?>
    <!-- Icon OR Image Choice Field -->
    <div class="form-group">
        <label class="form-label">
            <?= e($subField['label']) ?>
        </label>
        
        <?php
        // Get current values
        $iconType = $item['icon_type'] ?? 'emoji';
        $iconValue = $subFieldValue;
        $iconSize = $item['icon_size'] ?? 'medium-square';
        ?>
        
        <!-- Selection: Emoji or Image -->
        <div style="margin-bottom: 10px;">
            <label style="display: inline-flex; align-items: center; gap: 5px; margin-right: 15px;">
                <input type="radio" 
                       name="block_data[<?= $blockId ?>][<?= $fieldKey ?>][<?= $index ?>][icon_type]" 
                       value="emoji" 
                       <?= $iconType === 'emoji' ? 'checked' : '' ?>
                       onchange="toggleIconType(this, '<?= e($subFieldId) ?>')">
                <span>Emoji</span>
            </label>
            <label style="display: inline-flex; align-items: center; gap: 5px;">
                <input type="radio" 
                       name="block_data[<?= $blockId ?>][<?= $fieldKey ?>][<?= $index ?>][icon_type]" 
                       value="image" 
                       <?= $iconType === 'image' ? 'checked' : '' ?>
                       onchange="toggleIconType(this, '<?= e($subFieldId) ?>')">
                <span>Bild</span>
            </label>
        </div>
        
        <!-- Emoji Input -->
        <div id="emoji-input-<?= e($subFieldId) ?>" style="display: <?= $iconType === 'emoji' ? 'block' : 'none' ?>;">
            <input type="text" 
                   id="<?= e($subFieldId) ?>-emoji"
                   name="<?= e($subFieldName) ?>" 
                   class="form-input"
                   value="<?= $iconType === 'emoji' ? e($iconValue) : '' ?>"
                   placeholder="🐕 Emoji eingeben"
                   <?= $iconType !== 'emoji' ? 'disabled' : '' ?>
                   style="font-size: 24px;">
        </div>
        
        <!-- Image Upload -->
        <div id="image-input-<?= e($subFieldId) ?>" style="display: <?= $iconType === 'image' ? 'block' : 'none' ?>;">
            <!-- Image Size Selector -->
            <div class="form-group" style="margin-bottom: 10px;">
                <label class="form-label">Bildgröße:</label>
                <select name="block_data[<?= $blockId ?>][<?= $fieldKey ?>][<?= $index ?>][icon_size]" 
                        class="form-select" 
                        style="max-width: 300px;">
                    <option value="small-square" <?= $iconSize === 'small-square' ? 'selected' : '' ?>>
                        Klein Quadratisch (60x60px)
                    </option>
                    <option value="medium-square" <?= $iconSize === 'medium-square' ? 'selected' : '' ?>>
                        Mittel Quadratisch (80x80px)
                    </option>
                    <option value="large-square" <?= $iconSize === 'large-square' ? 'selected' : '' ?>>
                        Groß Quadratisch (120x120px)
                    </option>
                    <option value="small-rect" <?= $iconSize === 'small-rect' ? 'selected' : '' ?>>
                        Klein Rechteckig (100x60px)
                    </option>
                    <option value="medium-rect" <?= $iconSize === 'medium-rect' ? 'selected' : '' ?>>
                        Mittel Rechteckig (150x90px)
                    </option>
                    <option value="large-rect" <?= $iconSize === 'large-rect' ? 'selected' : '' ?>>
                        Groß Rechteckig (200x120px)
                    </option>
                </select>
            </div>
            
            <div class="image-field-buttons" style="display: flex; gap: 10px; margin-bottom: 10px;">
                <button type="button" class="btn btn-secondary btn-sm" 
                        onclick="openMediaLibrary('<?= e($subFieldId) ?>-image', <?= $blockId ?>, '<?= e($fieldKey) ?>.<?= $index ?>.<?= $subFieldKey ?>')">
                    📁 Aus Mediathek wählen
                </button>
                <label class="btn btn-secondary btn-sm" style="margin: 0; cursor: pointer;">
                    📤 Neue Datei hochladen
                    <input type="file" 
                           id="upload-<?= e($subFieldId) ?>-image"
                           name="block_images[<?= $blockId ?>][<?= $fieldKey ?>.<?= $index ?>.<?= $subFieldKey ?>]"
                           accept="image/*"
                           onchange="previewNewImage(this, '<?= e($subFieldId) ?>-image')"
                           style="display: none;">
                </label>
                <?php if ($iconType === 'image' && !empty($iconValue)): ?>
                    <button type="button" class="btn btn-danger btn-sm" 
                            onclick="removeIconImage('<?= e($subFieldId) ?>', <?= $blockId ?>, '<?= e($fieldKey) ?>', <?= $index ?>)"
                            title="Bild entfernen">
                        🗑️ Entfernen
                    </button>
                <?php endif; ?>
            </div>
            
            <!-- Hidden input stores filename -->
            <input type="hidden" 
                   id="hidden-<?= e($subFieldId) ?>-image"
                   name="<?= e($subFieldName) ?>"
                   value="<?= $iconType === 'image' ? e($iconValue) : '' ?>"
                   <?= $iconType !== 'image' ? 'disabled' : '' ?>>
            
            <?php if ($iconType === 'image' && !empty($iconValue)): ?>
                <div id="preview-container-<?= e($subFieldId) ?>-image" class="image-preview" style="margin-top: 10px;">
                    <img id="preview-<?= e($subFieldId) ?>-image" 
                         src="/media/pages/<?= e($iconValue) ?>"
                         alt="Icon Preview" 
                         style="max-width: 150px; max-height: 150px; border-radius: 8px; border: 2px solid #e5e7eb;">
                </div>
            <?php else: ?>
                <div id="preview-container-<?= e($subFieldId) ?>-image" class="image-preview" style="display: none; margin-top: 10px;">
                    <img id="preview-<?= e($subFieldId) ?>-image" 
                         src="" 
                         alt="Icon Preview" 
                         style="max-width: 150px; max-height: 150px; border-radius: 8px; border: 2px solid #e5e7eb;">
                </div>
            <?php endif; ?>
        </div>
    </div>
                                        
                                        <?php elseif ($subField['type'] === 'text'): ?>
                                            <div class="form-group">
                                                <label class="form-label" for="<?= e($subFieldId) ?>">
                                                    <?= e($subField['label']) ?>
                                                    <?php if ($subField['required'] ?? false): ?><span style="color: #ef4444;">*</span><?php endif; ?>
                                                </label>
                                                <input type="text" 
                                                       id="<?= e($subFieldId) ?>" 
                                                       name="<?= e($subFieldName) ?>" 
                                                       class="form-input"
                                                       value="<?= e($subFieldValue) ?>"
                                                       placeholder="<?= e($subField['placeholder'] ?? '') ?>"
                                                       <?= ($subField['required'] ?? false) ? 'required' : '' ?>>
                                            </div>
                                        
                                        <?php elseif ($subField['type'] === 'textarea'): ?>
                                            <div class="form-group">
                                                <label class="form-label" for="<?= e($subFieldId) ?>">
                                                    <?= e($subField['label']) ?>
                                                </label>
                                                <textarea id="<?= e($subFieldId) ?>" 
                                                          name="<?= e($subFieldName) ?>" 
                                                          class="form-textarea"
                                                          rows="<?= $subField['rows'] ?? 3 ?>"
                                                          placeholder="<?= e($subField['placeholder'] ?? '') ?>"><?= e($subFieldValue) ?></textarea>
                                            </div>
                                        
                                        <?php elseif ($subField['type'] === 'url'): ?>
                                            <div class="form-group">
                                                <label class="form-label" for="<?= e($subFieldId) ?>">
                                                    <?= e($subField['label']) ?>
                                                </label>
                                                <input type="url" 
                                                       id="<?= e($subFieldId) ?>" 
                                                       name="<?= e($subFieldName) ?>" 
                                                       class="form-input"
                                                       value="<?= e($subFieldValue) ?>"
                                                       placeholder="<?= e($subField['placeholder'] ?? 'https://') ?>">
                                            </div>
                                        
                                        <?php elseif ($subField['type'] === 'checkbox'): ?>
                                            <div class="form-group">
                                                <label class="form-label" style="display: flex; align-items: center; gap: 10px;">
                                                    <input type="checkbox" 
                                                           id="<?= e($subFieldId) ?>" 
                                                           name="<?= e($subFieldName) ?>" 
                                                           value="1"
                                                           <?= $subFieldValue ? 'checked' : '' ?>
                                                           style="width: auto; margin: 0;">
                                                    <span><?= e($subField['label']) ?></span>
                                                </label>
                                            </div>
                                        
                                        <?php elseif ($subField['type'] === 'image'): ?>
                                            <div class="form-group">
                                                <label class="form-label" for="<?= e($subFieldId) ?>">
                                                    <?= e($subField['label']) ?>
                                                </label>
                                                
                                                <div class="image-field-buttons" style="display: flex; gap: 10px; margin-bottom: 10px;">
                                                    <button type="button" class="btn btn-secondary btn-sm" 
                                                            onclick="openMediaLibrary('<?= e($subFieldId) ?>', <?= $blockId ?>, '<?= e($fieldKey) ?>.<?= $index ?>.<?= e($subFieldKey) ?>')">
                                                        📁 Aus Mediathek wählen
                                                    </button>
                                                    <label class="btn btn-secondary btn-sm" style="margin: 0; cursor: pointer;">
                                                        📤 Neue Datei hochladen
                                                        <input type="file" 
                                                               id="upload-<?= e($subFieldId) ?>"
                                                               name="block_images[<?= $blockId ?>][<?= $fieldKey ?>.<?= $index ?>.<?= $subFieldKey ?>]"
                                                               accept="image/*"
                                                               onchange="previewNewImage(this, '<?= e($subFieldId) ?>')"
                                                               style="display: none;">
                                                    </label>
                                                </div>
                                                
                                                <input type="hidden" 
                                                       id="hidden-<?= e($subFieldId) ?>"
                                                       name="<?= e($subFieldName) ?>"
                                                       value="<?= e($subFieldValue) ?>">
                                                
                                                <?php if (!empty($subFieldValue)): ?>
                                                    <div id="preview-container-<?= e($subFieldId) ?>" class="image-preview" style="margin-top: 10px;">
                                                        <img id="preview-<?= e($subFieldId) ?>" 
                                                             src="/media/pages/<?= e($subFieldValue) ?>"
                                                             alt="Preview" 
                                                             style="max-width: 300px; max-height: 200px; border-radius: 8px; border: 2px solid #e5e7eb;">
                                                    </div>
                                                <?php else: ?>
                                                    <div id="preview-container-<?= e($subFieldId) ?>" class="image-preview" style="display: none; margin-top: 10px;">
                                                        <img id="preview-<?= e($subFieldId) ?>" 
                                                             src="" 
                                                             alt="Preview" 
                                                             style="max-width: 300px; max-height: 200px; border-radius: 8px; border: 2px solid #e5e7eb;">
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        
                        <!-- REPEATER TEMPLATE -->
                        <div class="repeater-template" style="display: none;">
                            <div class="repeater-item">
                                <div class="repeater-item-header">
                                    <strong><?= e($field['item_label'] ?? 'Element') ?> #X</strong>
                                    <button type="button" 
                                            class="block-action-btn danger" 
                                            onclick="removeRepeaterItem(this)" 
                                            title="Entfernen">
                                        🗑️
                                    </button>
                                </div>
                                
                                <div class="repeater-item-content">
                                    <?php foreach ($field['fields'] as $subFieldKey => $subField): ?>
                                        <?php 
                                        $subFieldName = "block_data[{$blockId}][{$fieldKey}][0][{$subFieldKey}]";
                                        $subFieldId = "block_{$blockId}_{$fieldKey}_0_{$subFieldKey}";
                                        ?>
                                        
                                        <?php if ($subField['type'] === 'richtext'): ?>
                                            <?php 
                                            echo RichTextField::render(
                                                $subFieldId,
                                                $subFieldName,
                                                ['text' => ''],
                                                $subField['label'],
                                                $subField['required'] ?? false
                                            );
                                            ?>
                                        
                                        <?php elseif ($subField['type'] === 'text'): ?>
                                            <div class="form-group">
                                                <label class="form-label" for="<?= e($subFieldId) ?>">
                                                    <?= e($subField['label']) ?>
                                                </label>
                                                <input type="text" 
                                                       id="<?= e($subFieldId) ?>" 
                                                       name="<?= e($subFieldName) ?>" 
                                                       class="form-input"
                                                       placeholder="<?= e($subField['placeholder'] ?? '') ?>"
                                                       data-template-field="true">
                                            </div>
                                        
                                        <?php elseif ($subField['type'] === 'textarea'): ?>
                                            <div class="form-group">
                                                <label class="form-label" for="<?= e($subFieldId) ?>">
                                                    <?= e($subField['label']) ?>
                                                </label>
                                                <textarea id="<?= e($subFieldId) ?>" 
                                                          name="<?= e($subFieldName) ?>" 
                                                          class="form-textarea"
                                                          rows="<?= $subField['rows'] ?? 3 ?>"
                                                          placeholder="<?= e($subField['placeholder'] ?? '') ?>"
                                                          data-template-field="true"></textarea>
                                            </div>
                                        
                                        <?php elseif ($subField['type'] === 'url'): ?>
                                            <div class="form-group">
                                                <label class="form-label" for="<?= e($subFieldId) ?>">
                                                    <?= e($subField['label']) ?>
                                                </label>
                                                <input type="url" 
                                                       id="<?= e($subFieldId) ?>" 
                                                       name="<?= e($subFieldName) ?>" 
                                                       class="form-input"
                                                       placeholder="<?= e($subField['placeholder'] ?? 'https://') ?>"
                                                       data-template-field="true">
                                            </div>
                                        
                                        <?php elseif ($subField['type'] === 'checkbox'): ?>
                                            <div class="form-group">
                                                <label class="form-label" style="display: flex; align-items: center; gap: 10px;">
                                                    <input type="checkbox" 
                                                           id="<?= e($subFieldId) ?>" 
                                                           name="<?= e($subFieldName) ?>" 
                                                           value="1"
                                                           style="width: auto; margin: 0;"
                                                           data-template-field="true">
                                                    <span><?= e($subField['label']) ?></span>
                                                </label>
                                            </div>
                                        
                                        <?php elseif ($subField['type'] === 'image'): ?>
                                            <div class="form-group">
                                                <label class="form-label">
                                                    <?= e($subField['label']) ?>
                                                </label>
                                                
                                                <div class="image-field-buttons" style="display: flex; gap: 10px;">
                                                    <button type="button" class="btn btn-secondary btn-sm">
                                                        📁 Aus Mediathek wählen
                                                    </button>
                                                    <label class="btn btn-secondary btn-sm" style="margin: 0; cursor: pointer;">
                                                        📤 Neue Datei hochladen
                                                        <input type="file" accept="image/*" style="display: none;" data-template-field="true">
                                                    </label>
                                                </div>
                                                
                                                <input type="hidden" 
                                                       name="<?= e($subFieldName) ?>"
                                                       data-template-field="true">
                                            </div>
                                        
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <button type="button" class="btn btn-secondary btn-sm" onclick="addRepeaterItem(<?= $blockId ?>, '<?= e($fieldKey) ?>')">
                        ➕ <?= e($field['add_button'] ?? 'Element hinzufügen') ?>
                    </button>
                </div>
            
            <?php elseif ($field['type'] === 'richtext'): ?>
                <!-- Rich Text Editor Field (Non-Repeater) -->
                <?php 
                $richFieldValue = ['text' => ''];
                
                if (is_string($fieldValue)) {
                    $decoded = @json_decode($fieldValue, true);
                    if (is_array($decoded) && isset($decoded['text'])) {
                        $richFieldValue = $decoded;
                    } else {
                        $richFieldValue = ['text' => $fieldValue];
                    }
                } elseif (is_array($fieldValue)) {
                    $richFieldValue = $fieldValue;
                }
                
                echo RichTextField::render(
                    $fieldId,
                    $fieldName,
                    $richFieldValue,
                    $field['label'],
                    $field['required'] ?? false
                );
                ?>
            
            <?php elseif ($field['type'] === 'text'): ?>
                <div class="form-group">
                    <label class="form-label" for="<?= e($fieldId) ?>">
                        <?= e($field['label']) ?>
                        <?php if ($field['required'] ?? false): ?><span style="color: #ef4444;">*</span><?php endif; ?>
                    </label>
                    <input type="text" 
                           id="<?= e($fieldId) ?>" 
                           name="<?= e($fieldName) ?>" 
                           class="form-input"
                           value="<?= e($fieldValue) ?>"
                           placeholder="<?= e($field['placeholder'] ?? '') ?>"
                           <?= ($field['required'] ?? false) ? 'required' : '' ?>>
                    <?php if (!empty($field['help'])): ?>
                        <small style="display: block; margin-top: 5px; color: #6b7280;">
                            <?= e($field['help']) ?>
                        </small>
                    <?php endif; ?>
                </div>
            
            <?php elseif ($field['type'] === 'textarea'): ?>
                <div class="form-group">
                    <label class="form-label" for="<?= e($fieldId) ?>">
                        <?= e($field['label']) ?>
                        <?php if ($field['required'] ?? false): ?><span style="color: #ef4444;">*</span><?php endif; ?>
                    </label>
                    <textarea id="<?= e($fieldId) ?>" 
                              name="<?= e($fieldName) ?>" 
                              class="form-textarea"
                              rows="<?= $field['rows'] ?? 3 ?>"
                              placeholder="<?= e($field['placeholder'] ?? '') ?>"
                              <?= ($field['required'] ?? false) ? 'required' : '' ?>><?= e($fieldValue) ?></textarea>
                </div>
            
            <?php elseif ($field['type'] === 'select'): ?>
                <div class="form-group">
                    <label class="form-label" for="<?= e($fieldId) ?>">
                        <?= e($field['label']) ?>
                    </label>
                    <select id="<?= e($fieldId) ?>" name="<?= e($fieldName) ?>" class="form-select">
                        <?php foreach ($field['options'] as $optValue => $optLabel): ?>
                            <option value="<?= e($optValue) ?>" <?= $fieldValue === $optValue ? 'selected' : '' ?>>
                                <?= e($optLabel) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            
            <?php elseif ($field['type'] === 'checkbox'): ?>
                <div class="form-group">
                    <label class="form-label" style="display: flex; align-items: center; gap: 10px;">
                        <input type="checkbox" 
                               id="<?= e($fieldId) ?>" 
                               name="<?= e($fieldName) ?>" 
                               value="1"
                               <?= $fieldValue ? 'checked' : '' ?>
                               style="width: auto; margin: 0;">
                        <span><?= e($field['label']) ?></span>
                    </label>
                    <?php if (!empty($field['help'])): ?>
                        <small style="display: block; margin-top: 5px; color: #6b7280;">
                            <?= e($field['help']) ?>
                        </small>
                    <?php endif; ?>
                </div>
            
            <?php elseif ($field['type'] === 'image'): ?>
                <div class="form-group">
                    <label class="form-label" for="<?= e($fieldId) ?>">
                        <?= e($field['label']) ?>
                        <?php if ($field['required'] ?? false): ?><span style="color: #ef4444;">*</span><?php endif; ?>
                    </label>
                    
                    <div class="image-field-buttons" style="display: flex; gap: 10px; margin-bottom: 10px;">
                        <button type="button" class="btn btn-secondary btn-sm" 
                                onclick="openMediaLibrary('<?= e($fieldId) ?>', <?= $blockId ?>, '<?= e($fieldKey) ?>')">
                            📁 Aus Mediathek wählen
                        </button>
                        <label class="btn btn-secondary btn-sm" style="margin: 0; cursor: pointer;">
                            📤 Neue Datei hochladen
                            <input type="file" 
                                   id="upload-<?= e($fieldId) ?>"
                                   name="block_images[<?= $blockId ?>][<?= $fieldKey ?>]"
                                   accept="image/*"
                                   onchange="previewNewImage(this, '<?= e($fieldId) ?>')"
                                   style="display: none;">
                        </label>
                    </div>
                    
                    <input type="hidden" 
                           id="hidden-<?= e($fieldId) ?>"
                           name="<?= e($fieldName) ?>"
                           value="<?= e($fieldValue) ?>">
                    
                    <?php if (!empty($fieldValue)): ?>
                        <div id="preview-container-<?= e($fieldId) ?>" class="image-preview" style="margin-top: 10px;">
                            <img id="preview-<?= e($fieldId) ?>" 
                                 src="/media/pages/<?= e($fieldValue) ?>"
                                 alt="Preview" 
                                 style="max-width: 300px; max-height: 200px; border-radius: 8px; border: 2px solid #e5e7eb;">
                        </div>
                    <?php else: ?>
                        <div id="preview-container-<?= e($fieldId) ?>" class="image-preview" style="display: none; margin-top: 10px;">
                            <img id="preview-<?= e($fieldId) ?>" 
                                 src="" 
                                 alt="Preview" 
                                 style="max-width: 300px; max-height: 200px; border-radius: 8px; border: 2px solid #e5e7eb;">
                        </div>
                    <?php endif; ?>
                </div>
            
            <?php elseif ($field['type'] === 'color'): ?>
                <div class="form-group">
                    <label class="form-label" for="<?= e($fieldId) ?>">
                        <?= e($field['label']) ?>
                    </label>
                    <input type="color" 
                           id="<?= e($fieldId) ?>" 
                           name="<?= e($fieldName) ?>" 
                           class="form-input"
                           value="<?= e($fieldValue) ?>"
                           style="width: 100px; height: 40px;">
                </div>
            
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
</div>