<?php
/**
 * cms-core/public/webview/admin/logo_selector.php
 * Returns list of images from media/logo/ directory
 */

require_once __DIR__ . '/../../../backend/authorization/check_admin.php';

header('Content-Type: application/json');

$response = ['images' => []];

try {
    $logoDir = APP_ROOT . '/media/logo';
    
    // Create logo directory if it doesn't exist
    if (!is_dir($logoDir)) {
        mkdir($logoDir, 0755, true);
    }
    
    $images = [];
    
    if (is_dir($logoDir)) {
        $files = scandir($logoDir);
        foreach ($files as $file) {
            if ($file === '.' || $file === '..') continue;
            
            $filePath = $logoDir . '/' . $file;
            if (!is_file($filePath)) continue;
            
            // Check if it's an image
            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
            if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'])) {
                $images[] = [
                    'filename' => $file,
                    'path' => 'logo/' . $file,
                    'size' => filesize($filePath),
                    'modified' => filemtime($filePath)
                ];
            }
        }
    }
    
    // Sort by modified date (newest first)
    usort($images, function($a, $b) {
        return $b['modified'] - $a['modified'];
    });
    
    $response['images'] = $images;
    $response['count'] = count($images);
    $response['success'] = true;
    
} catch (Exception $e) {
    $response['success'] = false;
    $response['error'] = $e->getMessage();
}

echo json_encode($response);