<?php
/** 
 * cms-core/public/webview/admin/media_selector.php 
 * FIXED: Load images from root /media/pages (outside cms-core)
 */

require_once __DIR__ . '/../../../backend/authorization/check_admin.php';
require_once __DIR__ . '/../../../backend/core/init.php';

header('Content-Type: application/json');

try {
    // FIXED: Use APP_ROOT instead of relative path
    $mediaDir = APP_ROOT . '/media/pages';
    $images = [];
    
    // Create directory if doesn't exist
    if (!is_dir($mediaDir)) {
        mkdir($mediaDir, 0755, true);
    }
    
    if (is_dir($mediaDir)) {
        $files = scandir($mediaDir);
        foreach ($files as $file) {
            if ($file === '.' || $file === '..') continue;
            
            $filePath = $mediaDir . '/' . $file;
            if (!is_file($filePath)) continue;
            
            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
            if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'])) {
                $images[] = [
                    'filename' => $file,
                    'url' => '/media/pages/' . $file,
                    'size' => filesize($filePath),
                    'modified' => filemtime($filePath)
                ];
            }
        }
    }
    
    // Sort by modified date (newest first)
    usort($images, function($a, $b) {
        return $b['modified'] - $a['modified'];
    });
    
    echo json_encode([
        'success' => true, 
        'images' => $images,
        'count' => count($images),
        'path_checked' => $mediaDir // DEBUG: shows which path was checked
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}