<?php
/**
 * cms-core/public/webview/admin/reset_admin_password.php
 * Access ONCE, then DELETE this file!
 */

// Prevent headers issues
ob_start();

require_once __DIR__ . '/../../../backend/core/init.php';

$message = '';
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $newPassword = $_POST['new_password'] ?? '';
    
    if (empty($username) || empty($newPassword)) {
        $message = '❌ Username and password required';
    } else {
        // Hash the new password
        $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);
        
        // Update in database
        try {
            $result = db()->execute(
                "UPDATE users SET password = ? WHERE username = ?",
                [$hashedPassword, $username]
            );
            
            if ($result) {
                $success = true;
                $message = "✅ Password reset successful for user: " . htmlspecialchars($username);
                $message .= "<br><br><strong>⚠️ IMPORTANT: DELETE THIS FILE NOW!</strong>";
                $message .= "<br>File: reset_admin_password.php";
                $message .= "<br><br><a href='login.php' style='color:blue;'>Go to Login Page</a>";
            } else {
                $message = '❌ User not found or update failed';
            }
        } catch (Exception $e) {
            $message = '❌ Error: ' . $e->getMessage();
        }
    }
}

ob_end_flush();
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Reset Admin Password</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .reset-container {
            background: white;
            padding: 40px;
            border-radius: 16px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 500px;
            width: 100%;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
        }
        .warning {
            background: #fef3c7;
            border: 2px solid #f59e0b;
            color: #92400e;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .success {
            background: #d1fae5;
            border: 2px solid #10b981;
            color: #065f46;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .error {
            background: #fee2e2;
            border: 2px solid #ef4444;
            color: #991b1b;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            font-weight: 600;
            margin-bottom: 8px;
            color: #555;
        }
        input {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
        }
        input:focus {
            outline: none;
            border-color: #667eea;
        }
        .btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="reset-container">
        <h1>🔐 Emergency Password Reset</h1>
        
        <div class="warning">
            ⚠️ <strong>SECURITY WARNING:</strong> Delete this file immediately after use!
        </div>
        
        <?php if ($message): ?>
            <div class="<?= $success ? 'success' : 'error' ?>">
                <?= $message ?>
            </div>
        <?php endif; ?>
        
        <?php if (!$success): ?>
        <form method="POST">
            <div class="form-group">
                <label>Username (usually "admin"):</label>
                <input type="text" name="username" value="admin" required>
            </div>
            
            <div class="form-group">
                <label>New Password:</label>
                <input type="password" name="new_password" required>
                <small style="color:#666;font-size:13px;">Minimum 8 characters</small>
            </div>
            
            <button type="submit" class="btn">Reset Password</button>
        </form>
        <?php endif; ?>
    </div>
</body>
</html>