<?php
/** cms-core/public/webview/admin/security-monitor.php */

require_once dirname(__DIR__, 3) . '/backend/core/init.php';
require_once dirname(__DIR__, 3) . '/backend/core/admin_check.php';
require_once dirname(__DIR__, 3) . '/backend/security/SecurityMonitor.php';

$pageTitle = 'Security Monitor';

// Hole Security-Daten
$stats = SecurityMonitor::getStats(7);
$recentEvents = SecurityMonitor::getRecentEvents(50);

// Zähle nach Severity
$severityCounts = [
    'low' => 0,
    'medium' => 0,
    'high' => 0,
    'critical' => 0
];

foreach ($stats as $stat) {
    $severityCounts[$stat['severity']] += $stat['count'];
}

require_once 'includes/header.php';
?>

<style>
.security-dashboard {
    padding: 20px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.stat-card {
    background: white;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    border-left: 4px solid;
}

.stat-card.low { border-left-color: #10b981; }
.stat-card.medium { border-left-color: #f59e0b; }
.stat-card.high { border-left-color: #ef4444; }
.stat-card.critical { border-left-color: #7c3aed; }

.stat-card h3 {
    margin: 0 0 10px 0;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: #6b7280;
}

.stat-card .number {
    font-size: 32px;
    font-weight: bold;
    margin: 0;
}

.stat-card.low .number { color: #10b981; }
.stat-card.medium .number { color: #f59e0b; }
.stat-card.high .number { color: #ef4444; }
.stat-card.critical .number { color: #7c3aed; }

.events-table {
    background: white;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    overflow-x: auto;
}

.events-table h2 {
    margin-top: 0;
}

table {
    width: 100%;
    border-collapse: collapse;
}

table th {
    text-align: left;
    padding: 12px;
    background: #f3f4f6;
    font-weight: 600;
    border-bottom: 2px solid #e5e7eb;
}

table td {
    padding: 12px;
    border-bottom: 1px solid #e5e7eb;
}

table tr:hover {
    background: #f9fafb;
}

.severity-badge {
    display: inline-block;
    padding: 4px 12px;
    border-radius: 4px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.severity-low { background: #d1fae5; color: #065f46; }
.severity-medium { background: #fed7aa; color: #92400e; }
.severity-high { background: #fecaca; color: #991b1b; }
.severity-critical { background: #ddd6fe; color: #5b21b6; }

.ip-address {
    font-family: monospace;
    background: #f3f4f6;
    padding: 2px 6px;
    border-radius: 3px;
}

.event-type {
    font-weight: 600;
    color: #374151;
}

.timestamp {
    color: #6b7280;
    font-size: 14px;
}

.details-toggle {
    cursor: pointer;
    color: #3b82f6;
    text-decoration: underline;
}

.event-details {
    display: none;
    margin-top: 10px;
    padding: 10px;
    background: #f9fafb;
    border-radius: 4px;
    font-size: 13px;
}

.event-details.show {
    display: block;
}

.no-events {
    text-align: center;
    padding: 40px;
    color: #6b7280;
}

.refresh-btn {
    float: right;
    background: #3b82f6;
    color: white;
    border: none;
    padding: 8px 16px;
    border-radius: 4px;
    cursor: pointer;
    font-size: 14px;
}

.refresh-btn:hover {
    background: #2563eb;
}
</style>

<div class="security-dashboard">
    <h1>🔒 Security Monitor</h1>
    <p>Überwachung verdächtiger Aktivitäten der letzten 7 Tage</p>

    <div class="stats-grid">
        <div class="stat-card low">
            <h3>Low Severity</h3>
            <p class="number"><?php echo number_format($severityCounts['low']); ?></p>
        </div>
        
        <div class="stat-card medium">
            <h3>Medium Severity</h3>
            <p class="number"><?php echo number_format($severityCounts['medium']); ?></p>
        </div>
        
        <div class="stat-card high">
            <h3>High Severity</h3>
            <p class="number"><?php echo number_format($severityCounts['high']); ?></p>
        </div>
        
        <div class="stat-card critical">
            <h3>Critical Severity</h3>
            <p class="number"><?php echo number_format($severityCounts['critical']); ?></p>
        </div>
    </div>

    <div class="events-table">
        <h2>
            Letzte Security-Events
            <button class="refresh-btn" onclick="location.reload()">↻ Aktualisieren</button>
        </h2>
        
        <?php if (empty($recentEvents)): ?>
            <div class="no-events">
                <p>✅ Keine Security-Events gefunden</p>
                <p>Ihr System läuft sicher!</p>
            </div>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>Zeitpunkt</th>
                        <th>Event</th>
                        <th>Severity</th>
                        <th>IP-Adresse</th>
                        <th>Details</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recentEvents as $event): ?>
                        <tr>
                            <td class="timestamp">
                                <?php echo date('d.m.Y H:i:s', strtotime($event['created_at'])); ?>
                            </td>
                            <td>
                                <span class="event-type">
                                    <?php echo htmlspecialchars($event['event_type']); ?>
                                </span>
                            </td>
                            <td>
                                <span class="severity-badge severity-<?php echo $event['severity']; ?>">
                                    <?php echo $event['severity']; ?>
                                </span>
                            </td>
                            <td>
                                <span class="ip-address">
                                    <?php echo htmlspecialchars($event['ip_address']); ?>
                                </span>
                            </td>
                            <td>
                                <span class="details-toggle" onclick="toggleDetails(<?php echo $event['id']; ?>)">
                                    Details anzeigen
                                </span>
                                <div id="details-<?php echo $event['id']; ?>" class="event-details">
                                    <strong>Request URI:</strong> <?php echo htmlspecialchars($event['request_uri']); ?><br>
                                    <strong>User Agent:</strong> <?php echo htmlspecialchars(substr($event['user_agent'], 0, 100)); ?><br>
                                    <?php if ($event['user_id']): ?>
                                        <strong>User ID:</strong> <?php echo $event['user_id']; ?><br>
                                    <?php endif; ?>
                                    <?php if ($event['details']): ?>
                                        <strong>Details:</strong>
                                        <pre style="margin: 5px 0 0 0; overflow-x: auto;"><?php 
                                            echo htmlspecialchars(json_encode(json_decode($event['details']), JSON_PRETTY_PRINT)); 
                                        ?></pre>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>

    <div class="events-table" style="margin-top: 20px;">
        <h2>Event-Typen Übersicht</h2>
        <table>
            <thead>
                <tr>
                    <th>Event-Typ</th>
                    <th>Severity</th>
                    <th>Anzahl</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($stats as $stat): ?>
                    <tr>
                        <td class="event-type"><?php echo htmlspecialchars($stat['event_type']); ?></td>
                        <td>
                            <span class="severity-badge severity-<?php echo $stat['severity']; ?>">
                                <?php echo $stat['severity']; ?>
                            </span>
                        </td>
                        <td><strong><?php echo number_format($stat['count']); ?></strong></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function toggleDetails(id) {
    const details = document.getElementById('details-' + id);
    details.classList.toggle('show');
}

// Auto-refresh alle 30 Sekunden
setTimeout(() => {
    location.reload();
}, 30000);
</script>

<?php require_once 'includes/footer.php'; ?>