<?php
/** cms-core/public/webview/admin/sitemap_manage.php */

require_once __DIR__ . '/../../../backend/authorization/check_admin.php';
require_once __DIR__ . '/../../../backend/core/SitemapGenerator.php';

$error = '';
$success = '';
$sitemapExists = file_exists(APP_ROOT . '/sitemap.xml');
$sitemapUrl = APP_URL . '/sitemap.xml';
$lastGenerated = $sitemapExists ? date('d.m.Y H:i:s', filemtime(APP_ROOT . '/sitemap.xml')) : 'Nie';

// Handle actions
if (is_post()) {
    try {
        CSRF::require();
    } catch (Exception $e) {
        set_flash('error', 'Ungültiger CSRF-Token.');
        error_log("CSRF validation failed: " . $e->getMessage());
        redirect('/cms-core/public/webview/admin/sitemap_manage.php');
        exit;
    }
    
    $action = post('action');
    
if ($action === 'generate') {
    try {
        // Erstelle Instanz
        $generator = new SitemapGenerator();
        $result = $generator->save();
        
        if ($result['success']) {
            set_flash('success', "✅ Sitemap erfolgreich generiert! {$result['pages']} Seiten hinzugefügt.");
        } else {
            set_flash('error', 'Fehler beim Generieren: ' . ($result['error'] ?? 'Unbekannter Fehler'));
        }
    } catch (Exception $e) {
        set_flash('error', 'Fehler beim Generieren: ' . $e->getMessage());
        error_log("Sitemap generation error: " . $e->getMessage());
    }
    
    redirect('/admin/sitemap_manage.php');
    exit;
}

    if ($action === 'delete') {
        if (file_exists(APP_ROOT . '/sitemap.xml')) {
            unlink(APP_ROOT . '/sitemap.xml');
            set_flash('success', 'Sitemap erfolgreich gelöscht.');
        } else {
            set_flash('error', 'Sitemap existiert nicht.');
        }
        redirect('/cms-core/public/webview/admin/sitemap_manage.php');
        exit;
    }
}

// Get pages count
$pagesCount = db()->fetchOne("SELECT COUNT(*) as count FROM pages WHERE status = 'published'")['count'];

$flashMessages = get_flash();
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sitemap</title>
<?php
$adminCssPath = APP_ROOT . '/assets/css/admin.css';
$adminCssVersion = file_exists($adminCssPath) ? filemtime($adminCssPath) : time();
?>
<link rel="stylesheet" href="/assets/css/admin.css?v=<?= $adminCssVersion ?>">
</head>
<body>
    <?php include 'includes/admin_header.php'; ?>
    
    <div class="admin-container">
        <?php include 'includes/admin_sidebar.php'; ?>
        
        <main class="admin-content">
            <?php foreach ($flashMessages as $flash): ?>
                <div class="alert alert-<?= e($flash['type']) ?>">
                    <?= e($flash['message']) ?>
                </div>
            <?php endforeach; ?>
            
            <div class="page-header">
                <div>
                    <h1>🗺️ Sitemap Generator</h1>
                    <p class="page-description">XML-Sitemap für Suchmaschinen generieren und verwalten</p>
                </div>
            </div>
            
            <!-- Status Card -->
            <div class="content-card">
                <div class="card-header">
                    <h2 class="card-title">Status</h2>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px;">
                    <div style="padding: 20px; background: <?= $sitemapExists ? '#efe' : '#fee' ?>; border-radius: 8px; text-align: center;">
                        <div style="font-size: 2rem; margin-bottom: 10px;">
                            <?= $sitemapExists ? '✅' : '❌' ?>
                        </div>
                        <div style="font-weight: 600; color: <?= $sitemapExists ? '#363' : '#c33' ?>;">
                            <?= $sitemapExists ? 'Sitemap existiert' : 'Keine Sitemap' ?>
                        </div>
                    </div>
                    
                    <div style="padding: 20px; background: #f0f9ff; border-radius: 8px; text-align: center;">
                        <div style="font-size: 2rem; margin-bottom: 10px;">📄</div>
                        <div style="font-weight: 600; color: #0369a1;"><?= $pagesCount ?> Seiten</div>
                        <div style="font-size: 0.85rem; color: #64748b;">Veröffentlicht</div>
                    </div>
                    
                    <div style="padding: 20px; background: #fef3c7; border-radius: 8px; text-align: center;">
                        <div style="font-size: 2rem; margin-bottom: 10px;">🕐</div>
                        <div style="font-weight: 600; color: #92400e;">Zuletzt generiert</div>
                        <div style="font-size: 0.85rem; color: #78350f;"><?= e($lastGenerated) ?></div>
                    </div>
                </div>
            </div>
            
            <!-- Info Card -->
            <div class="content-card">
                <div class="card-header">
                    <h2 class="card-title">ℹ️ Was ist eine Sitemap?</h2>
                </div>
                
                <p style="margin-bottom: 15px; line-height: 1.6;">
                    Eine XML-Sitemap hilft Suchmaschinen wie Google, alle Seiten Ihrer Website zu finden und zu indexieren. 
                    Die Sitemap enthält eine Liste aller veröffentlichten Seiten mit wichtigen Informationen wie:
                </p>
                
                <ul style="margin-left: 20px; line-height: 1.8;">
                    <li>URL der Seite</li>
                    <li>Letztes Änderungsdatum</li>
                    <li>Änderungshäufigkeit</li>
                    <li>Priorität der Seite</li>
                </ul>
                
                <div style="margin-top: 20px; padding: 15px; background: #f0f9ff; border-left: 4px solid #0284c7; border-radius: 4px;">
                    <strong>💡 Tipp:</strong> Generieren Sie die Sitemap nach jeder größeren Änderung an Ihren Seiten neu.
                </div>
            </div>
            
            <!-- Actions Card -->
            <div class="content-card">
                <div class="card-header">
                    <h2 class="card-title">Aktionen</h2>
                </div>
                
                <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                    <!-- Generate Sitemap Form -->
                    <form method="POST" style="display: inline;">
                        <?= CSRF::field() ?>
                        <input type="hidden" name="action" value="generate">
                        <button type="submit" class="btn btn-primary">
                            🔄 Sitemap <?= $sitemapExists ? 'neu generieren' : 'generieren' ?>
                        </button>
                    </form>
                    
                    <?php if ($sitemapExists): ?>
                        <!-- View Sitemap -->
                        <a href="<?= $sitemapUrl ?>" target="_blank" class="btn btn-secondary">
                            👁️ Sitemap ansehen
                        </a>
                        
                        <!-- Delete Sitemap Form -->
                        <form method="POST" style="display: inline;" onsubmit="return confirm('Sitemap wirklich löschen?');">
                            <?= CSRF::field() ?>
                            <input type="hidden" name="action" value="delete">
                            <button type="submit" class="btn btn-danger">
                                🗑️ Sitemap löschen
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Google Search Console Info -->
            <div class="content-card">
                <div class="card-header">
                    <h2 class="card-title">📊 Google Search Console</h2>
                </div>
                
                <p style="margin-bottom: 15px; line-height: 1.6;">
                    Nach der Generierung sollten Sie die Sitemap in der Google Search Console einreichen:
                </p>
                
                <ol style="margin-left: 20px; line-height: 1.8;">
                    <li>Gehen Sie zur <a href="https://search.google.com/search-console" target="_blank" style="color: #667eea;">Google Search Console</a></li>
                    <li>Wählen Sie Ihre Website aus</li>
                    <li>Navigieren Sie zu "Sitemaps"</li>
                    <li>Geben Sie die URL ein: <code style="background: #f3f4f6; padding: 2px 6px; border-radius: 4px;"><?= e($sitemapUrl) ?></code></li>
                    <li>Klicken Sie auf "Senden"</li>
                </ol>
                
                <div style="margin-top: 20px; padding: 15px; background: #fef3c7; border-left: 4px solid #f59e0b; border-radius: 4px;">
                    <strong>⚠️ Wichtig:</strong> Die Sitemap sollte nach größeren Änderungen neu generiert werden.
                </div>
            </div>
        </main>
    </div>
    
    <script src="/assets/js/main.js"></script>
</body>
</html>