<?php
/**
 * cms-core/public/webview/admin/welcome.php
 * CORRECTED - First-Time Setup Guide & Onboarding
 * 
 * Shows comprehensive guide after first login
 * Can be dismissed and re-accessed anytime
 */

require_once __DIR__ . '/../../../backend/authorization/check_admin.php';

// Check if user dismissed welcome
$showWelcome = !get_setting('welcome_dismissed', false);

// Handle dismiss
if (is_post() && post('action') === 'dismiss') {
    CSRF::require();
    
    db()->execute(
        "INSERT INTO settings (setting_key, setting_value) VALUES ('welcome_dismissed', '1') 
         ON DUPLICATE KEY UPDATE setting_value = '1'"
    );
    
    set_flash('success', 'Willkommensanleitung geschlossen. Du findest sie jederzeit unter Hilfe → Erste Schritte.');
    redirect('/cms-core/public/webview/admin/dashboard.php');
}

$flashMessages = get_flash();
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Willkommen! - CMS Admin</title>
<?php
$adminCssPath = APP_ROOT . '/assets/css/admin.css';
$adminCssVersion = file_exists($adminCssPath) ? filemtime($adminCssPath) : time();
?>
<link rel="stylesheet" href="/assets/css/admin.css?v=<?= $adminCssVersion ?>">
<style>
        .welcome-container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .welcome-hero {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 60px 40px;
            border-radius: 16px;
            text-align: center;
            margin-bottom: 40px;
        }
        
        .welcome-hero h1 {
            font-size: 48px;
            margin-bottom: 16px;
        }
        
        .welcome-hero p {
            font-size: 20px;
            opacity: 0.9;
        }
        
        .guide-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 24px;
            margin-bottom: 40px;
        }
        
        .guide-card {
            background: white;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 32px;
            transition: all 0.3s;
        }
        
        .guide-card:hover {
            border-color: #667eea;
            transform: translateY(-4px);
            box-shadow: 0 8px 24px rgba(102, 126, 234, 0.15);
        }
        
        .guide-icon {
            font-size: 48px;
            margin-bottom: 16px;
        }
        
        .guide-title {
            font-size: 22px;
            color: #1f2937;
            margin-bottom: 12px;
        }
        
        .guide-description {
            color: #6b7280;
            line-height: 1.6;
            margin-bottom: 20px;
        }
        
        /* Checklist Styles */
        .checklist {
            background: white;
            border-radius: 12px;
            padding: 0;
        }
        
        .checklist-item {
            display: flex;
            gap: 20px;
            padding: 24px;
            border-bottom: 1px solid #e5e7eb;
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .checklist-item:last-child {
            border-bottom: none;
        }
        
        .checklist-item:hover {
            background: #f9fafb;
        }
        
        .checklist-checkbox {
            width: 24px;
            height: 24px;
            border: 2px solid #d1d5db;
            border-radius: 6px;
            flex-shrink: 0;
            position: relative;
            transition: all 0.3s;
        }
        
        .checklist-item.checked .checklist-checkbox {
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-color: #667eea;
        }
        
        .checklist-item.checked .checklist-checkbox::after {
            content: '✓';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            font-weight: bold;
            font-size: 16px;
        }
        
        .checklist-content h4 {
            margin: 0 0 8px 0;
            color: #1f2937;
            font-size: 18px;
        }
        
        .checklist-content p {
            margin: 0 0 8px 0;
            color: #6b7280;
            line-height: 1.6;
        }
        
        .btn-link {
            display: inline-block;
            color: #667eea;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.2s;
        }
        
        .btn-link:hover {
            color: #5568d3;
            transform: translateX(4px);
        }
        
        .block-examples {
            display: flex;
            flex-direction: column;
            gap: 12px;
            margin-top: 16px;
        }
        
        .block-example {
            background: #f9fafb;
            padding: 12px 16px;
            border-radius: 8px;
            border-left: 4px solid #667eea;
            font-size: 14px;
            line-height: 1.6;
        }
        
        .block-example strong {
            color: #667eea;
        }
        
        .guide-steps {
            list-style: none;
            padding: 0;
            margin-top: 16px;
        }
        
        .guide-steps li {
            padding: 10px 0;
            border-bottom: 1px solid #f3f4f6;
            color: #4b5563;
            line-height: 1.6;
        }
        
        .guide-steps li:last-child {
            border-bottom: none;
        }
        
        .guide-steps li strong {
            color: #667eea;
        }
    </style>
</head>
<body>
    <?php include 'includes/admin_header.php'; ?>
    
    <div class="admin-container">
        <?php include 'includes/admin_sidebar.php'; ?>
        
        <main class="admin-content">
            <?php foreach ($flashMessages as $flash): ?>
                <div class="alert alert-<?= e($flash['type']) ?>">
                    <?= e($flash['message']) ?>
                </div>
            <?php endforeach; ?>
            
            <div class="welcome-container">
                <!-- Hero -->
                <div class="welcome-hero">
                    <div style="font-size: 64px; margin-bottom: 16px;">🚀</div>
                    <h1>Willkommen im CMS!</h1>
                    <p>In 8 Schritten zur fertigen Website - folge dieser Anleitung</p>
                </div>
                
                <!-- Quick Start Checklist -->
                <div class="content-card" style="margin-bottom: 40px;">
                    <div class="card-header">
                        <h2 class="card-title">✅ Quick Start Checklist</h2>
                        <p style="color: #6b7280; margin-top: 8px;">
                            Hake die Schritte ab, während du sie erledigst
                        </p>
                    </div>
                    
                    <div class="checklist">
                        <div class="checklist-item" onclick="toggleCheck(this)">
                            <div class="checklist-checkbox"></div>
                            <div class="checklist-content">
                                <h4>1. Design anpassen</h4>
                                <p>Gehe zu <strong>Design → Farbe & Schrift</strong> und wähle deine Markenfarben und Schriftarten</p>
                                <a href="/cms-core/public/webview/admin/farb_font.php" class="btn-link">→ Jetzt anpassen</a>
                            </div>
                        </div>
                        
                        <div class="checklist-item" onclick="toggleCheck(this)">
                            <div class="checklist-checkbox"></div>
                            <div class="checklist-content">
                                <h4>2. Logo hochladen</h4>
                                <p>Unter <strong>Einstellungen</strong> kannst du dein Firmenlogo hochladen (empfohlen: PNG, transparent)</p>
                                <a href="/cms-core/public/webview/admin/settings.php#logo" class="btn-link">→ Logo hochladen</a>
                            </div>
                        </div>
                        
                        <div class="checklist-item" onclick="toggleCheck(this)">
                            <div class="checklist-checkbox"></div>
                            <div class="checklist-content">
                                <h4>3. Startseite gestalten</h4>
                                <p>Bearbeite die <strong>Homepage</strong> mit flexiblen Blöcken (Hero, Text, Bilder, Kontaktformular)</p>
                                <a href="/cms-core/public/webview/admin/page_flexible_edit.php?slug=index" class="btn-link">→ Startseite bearbeiten</a>
                            </div>
                        </div>
                        
                        <div class="checklist-item" onclick="toggleCheck(this)">
                            <div class="checklist-checkbox"></div>
                            <div class="checklist-content">
                                <h4>4. Weitere Seiten erstellen</h4>
                                <p>Erstelle Seiten wie "Über uns", "Leistungen", "Kontakt" etc.</p>
                                <a href="/cms-core/public/webview/admin/page_create_edit.php" class="btn-link">→ Neue Seite erstellen</a>
                            </div>
                        </div>
                        
                        <div class="checklist-item" onclick="toggleCheck(this)">
                            <div class="checklist-checkbox"></div>
                            <div class="checklist-content">
                                <h4>5. Menü einrichten</h4>
                                <p>Verknüpfe deine Seiten mit der Navigation - erstelle auch Dropdown-Menüs für Unterseiten</p>
                                <a href="/cms-core/public/webview/admin/menu_manage.php" class="btn-link">→ Menü verwalten</a>
                            </div>
                        </div>
                        
                        <div class="checklist-item" onclick="toggleCheck(this)">
                            <div class="checklist-checkbox"></div>
                            <div class="checklist-content">
                                <h4>6. Kontaktdaten eintragen</h4>
                                <p>Trage unter <strong>Einstellungen</strong> deine Adresse, E-Mail, Telefon und Social Media Links ein</p>
                                <a href="/cms-core/public/webview/admin/settings.php#contact" class="btn-link">→ Kontaktdaten eintragen</a>
                            </div>
                        </div>
                        
                        <div class="checklist-item" onclick="toggleCheck(this)">
                            <div class="checklist-checkbox"></div>
                            <div class="checklist-content">
                                <h4>7. SEO optimieren</h4>
                                <p>Generiere deine Sitemap und stelle sie Google Search Console bereit</p>
                                <a href="/cms-core/public/webview/admin/sitemap_manage.php" class="btn-link">→ Sitemap generieren</a>
                            </div>
                        </div>
                        
                        <div class="checklist-item" onclick="toggleCheck(this)">
                            <div class="checklist-checkbox"></div>
                            <div class="checklist-content">
                                <h4>8. Website veröffentlichen</h4>
                                <p>Ändere in Einstellungen den <strong>Wartungsmodus</strong> auf "Deaktiviert" und deine Website geht live!</p>
                                <a href="/cms-core/public/webview/admin/settings.php#maintenance" class="btn-link">→ Website veröffentlichen</a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Detailed Guide Cards -->
                <h2 style="font-size: 32px; color: #1f2937; margin-bottom: 24px; text-align: center;">
                    📚 Ausführliche Anleitungen
                </h2>
                
                <div class="guide-grid">
                    <!-- Flexible Blocks Guide -->
                    <div class="guide-card">
                        <div class="guide-icon">🧩</div>
                        <h3 class="guide-title">Flexible Blöcke verstehen</h3>
                        <p class="guide-description">
                            Baue Seiten aus vorgefertigten Bausteinen - so funktioniert's
                        </p>
                        <div class="block-examples">
                            <div class="block-example">
                                <strong>🎯 Hero Banner:</strong> Großer Einstiegsbereich mit Bild, Titel, Text und Button
                            </div>
                            <div class="block-example">
                                <strong>📝 Text:</strong> Einfacher Textblock mit Überschrift und Fließtext
                            </div>
                            <div class="block-example">
                                <strong>🖼️ Text mit Bild:</strong> Text neben oder über einem Bild (rechts/links)
                            </div>
                            <div class="block-example">
                                <strong>📋 Leistungen:</strong> Grid mit Icons, Titeln und Beschreibungen
                            </div>
                            <div class="block-example">
                                <strong>💰 Preise:</strong> Preistabelle mit Paketen und Features
                            </div>
                            <div class="block-example">
                                <strong>📧 Kontaktformular:</strong> E-Mail-Formular mit Name, E-Mail, Nachricht
                            </div>
                            <div class="block-example">
                                <strong>❓ FAQ:</strong> Häufige Fragen mit ausklappbaren Antworten
                            </div>
                            <div class="block-example">
                                <strong>⭐ Testimonials:</strong> Kundenbewertungen mit Sternen
                            </div>
                        </div>
                    </div>
                    
                    <!-- Design System Guide -->
                    <div class="guide-card">
                        <div class="guide-icon">🎨</div>
                        <h3 class="guide-title">Design-System</h3>
                        <p class="guide-description">
                            Zentrale Design-Kontrolle für die gesamte Website
                        </p>
                        <ul class="guide-steps">
                            <li><strong>Primary Color:</strong> Hauptfarbe für Buttons, Links, wichtige Elemente</li>
                            <li><strong>Secondary Color:</strong> Akzentfarbe für Verläufe und Highlights</li>
                            <li><strong>Header Farben:</strong> Hintergrund und Text der Navigation</li>
                            <li><strong>Footer Farben:</strong> Hintergrund und Text des Footers</li>
                            <li><strong>Textfarben:</strong> Dunkel (Überschriften), Mittel (Fließtext), Hell (Hinweise)</li>
                            <li><strong>Schriftarten:</strong> Separate Fonts für Überschriften (H1-H6) und Fließtext</li>
                            <li>💡 Alle Änderungen wirken sofort auf der gesamten Website!</li>
                        </ul>
                    </div>
                    
                    <!-- SEO Guide -->
                    <div class="guide-card">
                        <div class="guide-icon">🔍</div>
                        <h3 class="guide-title">SEO Optimierung</h3>
                        <p class="guide-description">
                            Werde bei Google gefunden - Schritt für Schritt
                        </p>
                        <ul class="guide-steps">
                            <li><strong>Meta-Titel:</strong> Jede Seite hat ihren eigenen Titel (max. 60 Zeichen)</li>
                            <li><strong>Meta-Description:</strong> Kurzbeschreibung für Google (150-160 Zeichen)</li>
                            <li><strong>Sitemap generieren:</strong> System → Sitemap → "Neu generieren"</li>
                            <li><strong>Google Search Console:</strong> Reiche deine Sitemap bei Google ein</li>
                            <li><strong>robots.txt:</strong> Steuere, welche Bereiche gecrawlt werden</li>
                            <li><strong>Bilder optimieren:</strong> Verwende WebP Format, beschreibende Dateinamen</li>
                            <li>💡 Tipp: Aktualisiere die Sitemap nach jeder neuen Seite!</li>
                        </ul>
                    </div>
                </div>
                
                <!-- Action Buttons -->
                <div style="display: flex; gap: 16px; justify-content: center; margin-top: 40px; flex-wrap: wrap;">
                    <a href="/cms-core/public/webview/admin/dashboard.php" class="btn btn-secondary">
                        ← Zurück zum Dashboard
                    </a>
                    <form method="POST" style="display: inline;">
                        <?= CSRF::field() ?>
                        <input type="hidden" name="action" value="dismiss">
                        <button type="submit" class="btn btn-primary">
                            ✓ Anleitung gelesen - Schließen
                        </button>
                    </form>
                </div>
                
                <div style="text-align: center; margin-top: 24px; color: #6b7280; font-size: 14px;">
                    💡 Du findest diese Anleitung jederzeit unter <strong>Hilfe → Erste Schritte</strong>
                </div>
            </div>
        </main>
    </div>
    
    <script>
    // Checklist toggle with persistence
    function toggleCheck(item) {
        item.classList.toggle('checked');
        saveChecklistState();
    }
    
    function saveChecklistState() {
        const checked = [];
        document.querySelectorAll('.checklist-item.checked').forEach((item, index) => {
            checked.push(index);
        });
        localStorage.setItem('welcome_checklist', JSON.stringify(checked));
    }
    
    function loadChecklistState() {
        try {
            const saved = localStorage.getItem('welcome_checklist');
            if (saved) {
                const checked = JSON.parse(saved);
                document.querySelectorAll('.checklist-item').forEach((item, index) => {
                    if (checked.includes(index)) {
                        item.classList.add('checked');
                    }
                });
            }
        } catch (e) {
            console.error('Failed to load checklist state');
        }
    }
    
    // Load state on page load
    document.addEventListener('DOMContentLoaded', loadChecklistState);
    </script>
    <!-- CRITICAL: Add main.js for mobile menu functionality -->
    <script src="/assets/js/main.js"></script>
</body>
</html>