/** cms-core/public/webview/assets/js/main.js */

document.addEventListener('DOMContentLoaded', () => {
    console.log('main.js loaded');

    // Admin Sidebar Toggle (only if elements exist - admin pages only)
    const toggleButton = document.querySelector('.admin-sidebar-toggle');
    const sidebar = document.querySelector('.admin-sidebar');

    if (toggleButton && sidebar) {
        console.log('Admin sidebar toggle initialized');

        toggleButton.addEventListener('click', (e) => {
            e.preventDefault();
            e.stopPropagation();
            sidebar.classList.toggle('open');
            toggleButton.classList.toggle('open');
        });

        toggleButton.addEventListener('touchstart', (e) => {
            e.preventDefault();
            sidebar.classList.toggle('open');
            toggleButton.classList.toggle('open');
        });

        document.addEventListener('click', (e) => {
            if (!e.target.closest('.admin-sidebar') && !e.target.closest('.admin-sidebar-toggle') && sidebar.classList.contains('open')) {
                sidebar.classList.remove('open');
                toggleButton.classList.remove('open');
            }
        });
    }
    // NOTE: Removed error logging - it's normal for frontend pages not to have admin elements
});