<?php
/** 
 * cms-core/public/webview/blocks/bekannt_aus.php
 * Partner/Media Logo Section - MOBILE OPTIMIZED: 4-6 logos per row
 */
// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? ['text' => 'Bekannt aus'];
$subtitle = $data['subtitle'] ?? ['text' => ''];
$logos = $data['logos'] ?? [];

$blockId = 'bekannt-' . uniqid();
?>

<section class="bekannt-aus-section" id="<?= $blockId ?>">
    <div class="container">
        <?php if (!empty($title['text'])): ?>
            <div class="bekannt-title">
                <?= render_richtext($title, 'h2') ?>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($subtitle['text'])): ?>
            <div class="bekannt-subtitle">
                <?= render_richtext($subtitle, 'p') ?>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($logos)): ?>
            <div class="bekannt-logos-grid">
                <?php foreach ($logos as $logo): ?>
                    <?php
                    $name = $logo['name'] ?? '';
                    $link = $logo['link'] ?? '';
                    $iconType = $logo['icon_type'] ?? 'emoji';
                    $iconValue = $logo['icon'] ?? '';
                    $iconSize = $logo['icon_size'] ?? 'medium-square';
                    
                    if (empty($name)) continue;
                    
                    $hasIcon = !empty($iconValue);
                    $isImage = ($iconType === 'image');
                    ?>
                    
                    <div class="bekannt-logo-item">
                        <?php if ($link): ?>
                            <a href="<?= e($link) ?>" 
                               target="_blank" 
                               rel="noopener noreferrer"
                               class="bekannt-logo-link">
                        <?php endif; ?>
                        
                        <div class="bekannt-logo-content">
                            <?php if ($hasIcon): ?>
                                <?php if ($isImage): ?>
                                    <img src="/media/pages/<?= e($iconValue) ?>" 
                                         alt="<?= e($name) ?>"
                                         class="bekannt-logo-img size-<?= e($iconSize) ?>">
                                <?php else: ?>
                                    <span class="bekannt-logo-emoji">
                                        <?= e($iconValue) ?>
                                    </span>
                                <?php endif; ?>
                            <?php endif; ?>
                            
                            <span class="bekannt-logo-name">
                                <?= e($name) ?>
                            </span>
                        </div>
                        
                        <?php if ($link): ?>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="bekannt-empty">
                <p style="color: #9ca3af;">Noch keine Partner hinzugefügt</p>
            </div>
        <?php endif; ?>
    </div>
</section>

<style>
/* ===============================================
   BEKANNT AUS BLOCK - MOBILE OPTIMIZED
   Mobile: 4-6 logos inline, Desktop: adaptive
   =============================================== */

#<?= $blockId ?> {
    padding: 0rem 0;
    text-align: center;
}

#<?= $blockId ?> .container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1.5rem;
}

/* Title */
#<?= $blockId ?> .bekannt-title {
    font-size: 2rem;
    font-weight: 700;
    text-align: center;
    margin-bottom: 1rem;
}

#<?= $blockId ?> .bekannt-title * {
    text-align: center !important;
    margin-left: auto;
    margin-right: auto;
}

/* Subtitle */
#<?= $blockId ?> .bekannt-subtitle {
    text-align: center;
    font-size: 1.125rem;
    margin-bottom: 3rem;
    max-width: 700px;
    margin-left: auto;
    margin-right: auto;
}

#<?= $blockId ?> .bekannt-subtitle * {
    text-align: center !important;
}

/* Grid without subtitle */
#<?= $blockId ?> .bekannt-title + .bekannt-logos-grid {
    margin-top: 2rem;
}

/* Grid Layout - MOBILE: 4-6 logos inline
   Uses flexbox for natural wrapping */
#<?= $blockId ?> .bekannt-logos-grid {
    display: flex;
    flex-wrap: wrap;
    gap: 0.75rem;
    justify-content: center;
    align-items: center;
    max-width: 1100px;
    margin: 0 auto;
}

/* Individual Logo Item - MOBILE OPTIMIZED
   Smaller width = more logos per row */
#<?= $blockId ?> .bekannt-logo-item {
    flex: 0 0 auto;
    width: calc(16.666% - 0.625rem); /* 6 per row on mobile */
    min-width: 60px;
    max-width: 100px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0.75rem;
    transition: all 0.3s ease;
    min-height: 70px;
}

#<?= $blockId ?> .bekannt-logo-item:hover {
    transform: translateY(-3px);
}

#<?= $blockId ?> .bekannt-logo-link {
    display: block;
    width: 100%;
    height: 100%;
    text-decoration: none;
    color: inherit;
}

/* Logo Content Container */
#<?= $blockId ?> .bekannt-logo-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    width: 100%;
}

/* Image Logos - Smaller on mobile */
#<?= $blockId ?> .bekannt-logo-img {
    object-fit: contain;
    filter: grayscale(100%);
    opacity: 0.7;
    transition: all 0.3s ease;
}

#<?= $blockId ?> .bekannt-logo-item:hover .bekannt-logo-img {
    filter: grayscale(0%);
    opacity: 1;
}

/* Image Size Classes - MOBILE OPTIMIZED */
#<?= $blockId ?> .bekannt-logo-img.size-small-square {
    width: 40px;
    height: 40px;
}

#<?= $blockId ?> .bekannt-logo-img.size-medium-square {
    width: 50px;
    height: 50px;
}

#<?= $blockId ?> .bekannt-logo-img.size-large-square {
    width: 60px;
    height: 60px;
}

#<?= $blockId ?> .bekannt-logo-img.size-small-rect {
    width: 60px;
    height: 40px;
}

#<?= $blockId ?> .bekannt-logo-img.size-medium-rect {
    width: 80px;
    height: 50px;
}

#<?= $blockId ?> .bekannt-logo-img.size-large-rect {
    width: 100px;
    height: 60px;
}

/* Emoji Icons - Smaller on mobile */
#<?= $blockId ?> .bekannt-logo-emoji {
    font-size: 2rem;
    line-height: 1;
}

/* Partner Name - Smaller on mobile */
#<?= $blockId ?> .bekannt-logo-name {
    font-size: 0.65rem;
    font-weight: 600;
    color: #374151;
    text-align: center;
    word-break: break-word;
    line-height: 1.2;
}

#<?= $blockId ?> .bekannt-empty {
    text-align: center;
    padding: 3rem;
}

/* Small Mobile: 375px+ - Still 6 per row but slightly bigger */
@media (min-width: 375px) {
    #<?= $blockId ?> .bekannt-logo-item {
        min-width: 65px;
        max-width: 110px;
    }
    
    #<?= $blockId ?> .bekannt-logo-name {
        font-size: 0.7rem;
    }
}

/* Tablet: 640px+ - 5 items per row, bigger size */
@media (min-width: 640px) {
    #<?= $blockId ?> .bekannt-logos-grid {
        gap: 1.5rem;
    }
    
    #<?= $blockId ?> .bekannt-logo-item {
        width: calc(20% - 1.2rem); /* 5 per row */
        min-width: 100px;
        max-width: 160px;
        padding: 1rem;
        min-height: 90px;
    }
    
    #<?= $blockId ?> .bekannt-logo-img.size-small-square {
        width: 50px;
        height: 50px;
    }
    
    #<?= $blockId ?> .bekannt-logo-img.size-medium-square {
        width: 65px;
        height: 65px;
    }
    
    #<?= $blockId ?> .bekannt-logo-img.size-large-square {
        width: 80px;
        height: 80px;
    }
    
    #<?= $blockId ?> .bekannt-logo-emoji {
        font-size: 2.5rem;
    }
    
    #<?= $blockId ?> .bekannt-logo-name {
        font-size: 0.8rem;
    }
}

/* Desktop: 1024px+ - 4 items per row, full size */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 0rem 0;
    }
    
    #<?= $blockId ?> .bekannt-logos-grid {
        gap: 2.5rem;
    }
    
    #<?= $blockId ?> .bekannt-logo-item {
        width: calc(25% - 1.875rem); /* 4 per row */
        min-width: 150px;
        max-width: 240px;
        padding: 1.5rem;
        min-height: 100px;
    }
    
    #<?= $blockId ?> .bekannt-logo-img.size-small-square {
        width: 60px;
        height: 60px;
    }
    
    #<?= $blockId ?> .bekannt-logo-img.size-medium-square {
        width: 80px;
        height: 80px;
    }
    
    #<?= $blockId ?> .bekannt-logo-img.size-large-square {
        width: 120px;
        height: 120px;
    }
    
    #<?= $blockId ?> .bekannt-logo-img.size-small-rect {
        width: 100px;
        height: 60px;
    }
    
    #<?= $blockId ?> .bekannt-logo-img.size-medium-rect {
        width: 150px;
        height: 90px;
    }
    
    #<?= $blockId ?> .bekannt-logo-img.size-large-rect {
        width: 200px;
        height: 120px;
    }
    
    #<?= $blockId ?> .bekannt-logo-emoji {
        font-size: 3rem;
    }
    
    #<?= $blockId ?> .bekannt-logo-name {
        font-size: 0.9rem;
    }
    
    #<?= $blockId ?> .bekannt-title {
        font-size: 2.5rem;
    }
}

/* Large Desktop: 1280px+ - up to 5 items per row */
@media (min-width: 1280px) {
    #<?= $blockId ?> .bekannt-logo-item {
        width: calc(20% - 2rem); /* 5 per row */
        max-width: 220px;
    }
}
</style>