<?php
/** cms-core/public/webview/blocks/blog_posts.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? ['text' => 'Neueste Beiträge'];
$limit = $data['limit'] ?? 3;

$posts = db()->fetchAll(
    "SELECT * FROM blog_posts WHERE status = 'published' ORDER BY published_at DESC LIMIT ?",
    [(int)$limit]
);

if (empty($posts)) {
    return '';
}

$blockId = 'blog-' . uniqid();
?>

<section class="blog-posts" id="<?= $blockId ?>">
    <div class="container">
        <?= render_richtext($title, 'h2') ?>
        <div class="blog-grid">
            <?php foreach ($posts as $post): ?>
                <?php
                $featuredImage = $post['featured_image'] ?? '';
                if ($featuredImage && !str_starts_with($featuredImage, 'http')) {
                    $featuredImage = '/media/blog/' . $featuredImage;
                }
                ?>
                <article class="blog-card">
                    <?php if ($featuredImage): ?>
                        <img src="<?= e($featuredImage) ?>" alt="<?= e($post['title']) ?>">
                    <?php endif; ?>
                    <div class="blog-content">
                        <h3>
                            <a href="/blog/<?= e($post['slug']) ?>" class="blog-post-link">
                                <?= e($post['title']) ?>
                            </a>
                        </h3>
                        <p>
                            <?= e(substr($post['excerpt'] ?? '', 0, 150)) ?>...
                        </p>
                        <a href="/blog/<?= e($post['slug']) ?>" class="blog-readmore-link">
                            Weiterlesen →
                        </a>
                    </div>
                </article>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
/* ===============================================
   BLOG POSTS BLOCK
   =============================================== */

#<?= $blockId ?> {
    padding: 80px 20px;
}

#<?= $blockId ?> .container {
    max-width: 1200px;
    margin: 0 auto;
}

#<?= $blockId ?> h2 {
    text-align: center;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 60px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .blog-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 30px;
}

#<?= $blockId ?> .blog-card {
    background: var(--white, #ffffff);
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.07);
    transition: all 0.3s;
}

#<?= $blockId ?> .blog-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 12px rgba(0, 0, 0, 0.1);
}

#<?= $blockId ?> .blog-card img {
    width: 100%;
    height: 200px;
    object-fit: cover;
}

#<?= $blockId ?> .blog-content {
    padding: 25px;
}

#<?= $blockId ?> .blog-card h3 {
    font-size: 22px;
    margin-bottom: 15px;
}

#<?= $blockId ?> .blog-post-link {
    text-decoration: none;
    color: var(--text-dark, #1f2937);
    transition: color 0.3s;
}

#<?= $blockId ?> .blog-post-link:hover {
    color: var(--primary-color, #667eea);
}

#<?= $blockId ?> .blog-card p {
    line-height: 1.6;
    margin-bottom: 20px;
    color: var(--text-light, #6b7280);
}

#<?= $blockId ?> .blog-readmore-link {
    text-decoration: none;
    font-weight: 600;
    color: var(--primary-color, #667eea);
    transition: color 0.3s;
}

#<?= $blockId ?> .blog-readmore-link:hover {
    color: var(--secondary-color, #764ba2);
}

/* Tablet: 768px+ - 2 columns */
@media (min-width: 768px) {
    #<?= $blockId ?> .blog-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

/* Desktop: 1024px+ - 3 columns */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 100px 20px;
    }
    
    #<?= $blockId ?> .blog-grid {
        grid-template-columns: repeat(3, 1fr);
    }
}
</style>