<?php
/** cms-core/public/webview/blocks/business_hours.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? ['text' => 'Öffnungszeiten'];
$hours = $data['hours'] ?? [];

if (empty($hours)) {
    return '';
}

$blockId = 'hours-' . uniqid();
?>

<section class="business-hours-section" id="<?= $blockId ?>">
    <div class="container">
        <?= render_richtext($title, 'h2') ?>
        
        <div class="hours-card">
            <?php foreach ($hours as $index => $hour): ?>
                <?php 
                $isClosed = !empty($hour['closed']);
                $isLastItem = $index === count($hours) - 1;
                ?>
                <div class="hours-row <?= $isLastItem ? '' : 'hours-border' ?>">
                    <div class="hours-day">
                        <?= e($hour['day'] ?? '') ?>
                    </div>
                    <div class="hours-time <?= $isClosed ? 'hours-closed' : '' ?>">
                        <?php if ($isClosed): ?>
                            Geschlossen
                        <?php else: ?>
                            <?= e($hour['time'] ?? '') ?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
/* ===============================================
   BUSINESS HOURS BLOCK
   =============================================== */

#<?= $blockId ?> {
    padding: 80px 20px;
}

#<?= $blockId ?> .container {
    max-width: 600px;
    margin: 0 auto;
}

#<?= $blockId ?> h2 {
    text-align: center;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 40px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .hours-card {
    background: var(--white, #ffffff);
    padding: 40px;
    border-radius: 16px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.07);
}

#<?= $blockId ?> .hours-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px 0;
}

#<?= $blockId ?> .hours-border {
    border-bottom: 1px solid var(--border-color, #e5e7eb);
}

#<?= $blockId ?> .hours-day {
    font-weight: 600;
    font-size: 16px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .hours-time {
    font-size: 16px;
    color: var(--text-light, #4b5563);
}

#<?= $blockId ?> .hours-closed {
    font-style: italic;
    opacity: 0.6;
}

/* Tablet: 768px+ */
@media (min-width: 768px) {
    #<?= $blockId ?> h2 {
        font-size: 3rem;
    }
}

/* Desktop: 1024px+ */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 100px 20px;
    }
}
</style>