<?php
/** cms-core/public/webview/blocks/faq.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? ['text' => 'Häufig gestellte Fragen'];
$faqs = $data['faqs'] ?? [];

if (empty($faqs)) {
    return '';
}

$blockId = 'faq-' . uniqid();
?>

<section class="faq-section" id="<?= $blockId ?>">
    <div class="container">
        <?= render_richtext($title, 'h2') ?>
        
        <div class="faq-list">
            <?php foreach ($faqs as $index => $faq): ?>
                <div class="faq-item">
                    <button 
                        type="button" 
                        class="faq-question"
                        onclick="this.parentElement.classList.toggle('active'); this.querySelector('.faq-icon').style.transform = this.parentElement.classList.contains('active') ? 'rotate(180deg)' : 'rotate(0deg)';">
                        <span><?= e($faq['question'] ?? '') ?></span>
                        <span class="faq-icon">▼</span>
                    </button>
                    <div class="faq-answer">
                        <div class="faq-answer-content">
                            <?= nl2br(e($faq['answer'] ?? '')) ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
/* ===============================================
   FAQ BLOCK
   =============================================== */

#<?= $blockId ?> {
    padding: 80px 20px;
}

#<?= $blockId ?> .container {
    max-width: 900px;
    margin: 0 auto;
}

#<?= $blockId ?> h2 {
    text-align: center;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 60px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .faq-list {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

#<?= $blockId ?> .faq-item {
    border: 1px solid var(--border-color, #e5e7eb);
    border-radius: 12px;
    overflow: hidden;
    background: var(--white, #ffffff);
}

#<?= $blockId ?> .faq-question {
    width: 100%;
    padding: 20px 24px;
    text-align: left;
    background: var(--white, #ffffff);
    border: none;
    cursor: pointer;
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 18px;
    font-weight: 600;
    transition: background 0.3s;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .faq-question:hover {
    background: var(--bg-light, #f9fafb);
}

#<?= $blockId ?> .faq-icon {
    font-size: 24px;
    transition: transform 0.3s;
    color: var(--primary-color, #667eea);
}

#<?= $blockId ?> .faq-answer {
    max-height: 0;
    overflow: hidden;
    transition: max-height 0.3s ease;
}

#<?= $blockId ?> .faq-item.active .faq-answer {
    max-height: 500px;
}

#<?= $blockId ?> .faq-answer-content {
    padding: 0 24px 20px 24px;
    line-height: 1.8;
    color: var(--text-light, #4b5563);
}

/* Tablet: 768px+ */
@media (min-width: 768px) {
    #<?= $blockId ?> h2 {
        font-size: 3rem;
    }
}

/* Desktop: 1024px+ */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 100px 20px;
    }
}
</style>