<?php
/** cms-core/public/webview/blocks/hero_banner.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? ['text' => 'Willkommen'];
$subtitle = $data['subtitle'] ?? '';
$image = $data['image'] ?? $data['background_image'] ?? '';
$buttonText = $data['button_text'] ?? 'Mehr erfahren';
$buttonLink = $data['button_link'] ?? '#';
$showButton = isset($data['button_text']) && !empty($data['button_text']);
$isFullframe = $data['fullframe'] ?? false;

if ($image && !str_starts_with($image, 'http')) {
    $image = '/media/pages/' . $image;
}

$blockId = 'hero-' . uniqid();
?>

<?php if ($isFullframe): ?>
    <!-- FULLFRAME MODE: Image as full background -->
    <?php
    $bgStyle = $image 
        ? "background-image: url('" . e($image) . "'); background-size: cover; background-position: center;" 
        : "background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);";
    ?>
    <section class="hero-banner fullframe" id="<?= $blockId ?>" style="<?= $bgStyle ?>">
        <div class="hero-overlay"></div>
        <div class="container hero-content">
            <?= render_richtext($title, 'h1') ?>
            <?php if (!empty($subtitle)): ?>
                <?= render_richtext($subtitle, 'p') ?>
            <?php endif; ?>
            <?php if ($showButton): ?>
                <a href="<?= e($buttonLink) ?>" class="btn btn-white">
                    <?= e($buttonText) ?>
                </a>
            <?php endif; ?>
        </div>
    </section>

<?php else: ?>
    <!-- TWO COLUMN MODE: Image FIRST in HTML for mobile-first -->
    <section class="hero-banner two-column" id="<?= $blockId ?>">
        <div class="container">
            <div class="hero-grid">
                <!-- IMAGE FIRST (shows on top on mobile) -->
                <div class="hero-image">
                    <?php if ($image): ?>
                        <img src="<?= e($image) ?>" alt="Hero">
                    <?php else: ?>
                        <div class="hero-placeholder">
                            Bild hier
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- TEXT SECOND (shows below image on mobile) -->
                <div class="hero-text">
                    <?= render_richtext($title, 'h1') ?>
                    <?php if (!empty($subtitle)): ?>
                        <?= render_richtext($subtitle, 'p') ?>
                    <?php endif; ?>
                    <?php if ($showButton): ?>
                        <a href="<?= e($buttonLink) ?>" class="btn btn-primary">
                            <?= e($buttonText) ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<style>
/* ===============================================
   HERO BANNER - FULLFRAME MODE
   =============================================== */

#<?= $blockId ?>.hero-banner.fullframe {
    padding: 120px 20px;
    position: relative;
    min-height: 500px;
    display: flex;
    align-items: center;
    justify-content: center;
}

#<?= $blockId ?>.hero-banner.fullframe .hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.4);
}

#<?= $blockId ?>.hero-banner.fullframe .container {
    max-width: 1200px;
    margin: 0 auto;
    position: relative;
    z-index: 1;
    text-align: center;
}

#<?= $blockId ?>.hero-banner.fullframe h1 {
    color: white;
    font-size: 3rem;
    font-weight: 800;
    margin-bottom: 1.5rem;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
}

#<?= $blockId ?>.hero-banner.fullframe p {
    color: white;
    font-size: 1.25rem;
    margin-bottom: 2rem;
    text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
}

#<?= $blockId ?>.hero-banner.fullframe .btn-white {
    background: white;
    color: var(--primary-color);
    padding: 15px 40px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    display: inline-block;
    transition: all 0.3s;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
}

#<?= $blockId ?>.hero-banner.fullframe .btn-white:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.3);
}

/* ===============================================
   HERO BANNER - TWO COLUMN MODE
   =============================================== */

#<?= $blockId ?>.hero-banner.two-column {
    padding: 60px 20px;
}

#<?= $blockId ?>.hero-banner.two-column .container {
    max-width: 1200px;
    margin: 0 auto;
}

/* MOBILE FIRST: Single column, Image on top */
#<?= $blockId ?>.hero-banner.two-column .hero-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 40px;
    align-items: center;
}

/* Image appears FIRST on mobile */
#<?= $blockId ?>.hero-banner.two-column .hero-image {
    width: 100%;
    order: 1; /* Image on top */
}

#<?= $blockId ?>.hero-banner.two-column .hero-image img {
    width: 100%;
    height: auto;
    border-radius: 20px;
    display: block;
}

#<?= $blockId ?>.hero-banner.two-column .hero-placeholder {
    width: 100%;
    height: 300px;
    background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
}

/* Text appears BELOW image on mobile */
#<?= $blockId ?>.hero-banner.two-column .hero-text {
    text-align: center;
    order: 2; /* Text below image */
}

#<?= $blockId ?>.hero-banner.two-column .hero-text h1 {
    font-size: 2rem;
    font-weight: 800;
    margin-bottom: 1rem;
    color: var(--text-dark);
}

#<?= $blockId ?>.hero-banner.two-column .hero-text p {
    font-size: 1rem;
    line-height: 1.6;
    color: var(--text-light);
    margin-bottom: 1.5rem;
}

#<?= $blockId ?>.hero-banner.two-column .btn-primary {
    background: var(--primary-color);
    color: white;
    padding: 14px 32px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    display: inline-block;
    transition: all 0.3s;
}

#<?= $blockId ?>.hero-banner.two-column .btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
}

/* Tablet: 768px+ - Switch to 2 columns, TEXT LEFT / IMAGE RIGHT */
@media (min-width: 768px) {
    #<?= $blockId ?>.hero-banner.fullframe h1 {
        font-size: 3.5rem;
    }
    
    #<?= $blockId ?>.hero-banner.two-column {
        padding: 80px 20px;
    }
    
    #<?= $blockId ?>.hero-banner.two-column .hero-grid {
        grid-template-columns: 1fr 1fr;
        gap: 60px;
    }
    
    /* On tablet+: Text on LEFT (order 1), Image on RIGHT (order 2) */
    #<?= $blockId ?>.hero-banner.two-column .hero-text {
        order: 1;
        text-align: left;
    }
    
    #<?= $blockId ?>.hero-banner.two-column .hero-image {
        order: 2;
    }
    
    #<?= $blockId ?>.hero-banner.two-column .hero-text h1 {
        font-size: 2.5rem;
    }
    
    #<?= $blockId ?>.hero-banner.two-column .hero-text p {
        font-size: 1.125rem;
        line-height: 1.8;
    }
    
    #<?= $blockId ?>.hero-banner.two-column .hero-placeholder {
        height: 400px;
    }
}

/* Desktop: 1024px+ */
@media (min-width: 1024px) {
    #<?= $blockId ?>.hero-banner.fullframe h1 {
        font-size: 4rem;
    }
    
    #<?= $blockId ?>.hero-banner.two-column {
        padding: 100px 20px;
    }
    
    #<?= $blockId ?>.hero-banner.two-column .hero-text h1 {
        font-size: 3.5rem;
    }
    
    #<?= $blockId ?>.hero-banner.two-column .hero-text p {
        font-size: 1.25rem;
    }
    
    #<?= $blockId ?>.hero-banner.two-column .btn-primary {
        padding: 15px 40px;
    }
}
</style>