<?php
/** cms-core/public/webview/blocks/image_block.php - NO PLACEHOLDER */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$image = $data['image'] ?? '';
$caption = $data['caption'] ?? '';
$size = $data['size'] ?? 'large';

if ($image && !str_starts_with($image, 'http')) {
    $image = '/media/pages/' . $image;
}

if (empty($image)) {
    return '';
}

$widthMap = [
    'small' => '400px',
    'medium' => '800px',
    'large' => '1000px',
    'full' => '100%'
];
$maxWidth = $widthMap[$size] ?? '1000px';

$blockId = 'image-' . uniqid();
?>

<section class="image-block" id="<?= $blockId ?>">
    <div class="container" style="max-width: <?= $maxWidth ?>;">
        <img src="<?= e($image) ?>" alt="<?= get_richtext_plain($caption) ?>">
        <?php if (!empty($caption)): ?>
            <div class="image-caption">
                <?= render_richtext($caption, 'p') ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<style>
/* ===============================================
   IMAGE BLOCK
   =============================================== */

#<?= $blockId ?> {
    padding: 40px 20px;
}

#<?= $blockId ?> .container {
    margin: 0 auto;
    text-align: center;
}

#<?= $blockId ?> img {
    width: 100%;
    border-radius: 12px;
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
}

#<?= $blockId ?> .image-caption {
    margin-top: 15px;
    font-size: 14px;
    color: var(--text-light, #6b7280);
    font-style: italic;
}
</style>