<?php
/** cms-core/public/webview/blocks/kontakt_banner.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}
$title = $data['title'] ?? ['text' => 'Bereit für den nächsten Schritt?'];
$subtitle = $data['subtitle'] ?? '';
$buttonText = $data['button_text'] ?? 'Kontakt aufnehmen';
$buttonLink = $data['button_link'] ?? '/kontakt';

$blockId = 'banner-' . uniqid();
?>

<section class="kontakt-banner" id="<?= $blockId ?>">
    <div class="container">
        <?= render_richtext($title, 'h2') ?>
        <?php if (!empty($subtitle)): ?>
            <?= render_richtext($subtitle, 'p') ?>
        <?php endif; ?>
        <a href="<?= e($buttonLink) ?>" class="btn btn-white">
            <?= e($buttonText) ?>
        </a>
    </div>
</section>

<style>
/* ===============================================
   KONTAKT BANNER (CTA)
   =============================================== */

#<?= $blockId ?> {
    padding: 80px 20px;
    background: linear-gradient(135deg, var(--primary-color, #667eea) 0%, var(--secondary-color, #764ba2) 100%);
    text-align: center;
}

#<?= $blockId ?> .container {
    max-width: 900px;
    margin: 0 auto;
}

#<?= $blockId ?> h2 {
    font-size: 2.5rem;
    font-weight: 700;
    color: white;
    margin-bottom: 15px;
}

#<?= $blockId ?> p {
    font-size: 1.25rem;
    color: rgba(255, 255, 255, 0.9);
    margin-bottom: 30px;
}

#<?= $blockId ?> .btn-white {
    background: white;
    color: var(--primary-color, #667eea);
    padding: 15px 40px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    display: inline-block;
    transition: all 0.3s;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

#<?= $blockId ?> .btn-white:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.25);
}

/* Tablet: 768px+ */
@media (min-width: 768px) {
    #<?= $blockId ?> h2 {
        font-size: 3rem;
    }
}

/* Desktop: 1024px+ */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 100px 20px;
    }
}
</style>