<?php
/** cms-core/public/webview/blocks/kontakt_form.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? ['text' => 'Kontaktieren Sie uns'];
$subtitle = $data['subtitle'] ?? '';
$showPhone = $data['show_phone'] ?? true;
$showEmail = $data['show_email'] ?? true;

$blockId = 'kontakt-' . uniqid();
?>

<section class="kontakt-form" id="<?= $blockId ?>">
    <div class="container">
        <?= render_richtext($title, 'h2') ?>
        <?php if (!empty($subtitle)): ?>
            <?= render_richtext($subtitle, 'p') ?>
        <?php endif; ?>
        
        <form method="POST" action="/kontakt-submit.php" class="contact-form">
            <div class="form-group">
                <label>Name *</label>
                <input type="text" name="name" required>
            </div>
            
            <div class="form-group">
                <label>E-Mail *</label>
                <input type="email" name="email" required>
            </div>
            
            <?php if ($showPhone): ?>
            <div class="form-group">
                <label>Telefon</label>
                <input type="tel" name="phone">
            </div>
            <?php endif; ?>
            
            <div class="form-group">
                <label>Nachricht *</label>
                <textarea name="message" required rows="6"></textarea>
            </div>
            
            <button type="submit" class="btn btn-primary">
                Nachricht senden
            </button>
        </form>
    </div>
</section>

<style>
/* ===============================================
   KONTAKT FORM
   =============================================== */

#<?= $blockId ?> {
    padding: 80px 20px;
}

#<?= $blockId ?> .container {
    max-width: 800px;
    margin: 0 auto;
    text-align: center;
}

#<?= $blockId ?> h2 {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 15px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> p {
    font-size: 1.125rem;
    color: var(--text-light, #6b7280);
    margin-bottom: 40px;
}

#<?= $blockId ?> .contact-form {
    background: var(--white, #ffffff);
    padding: 40px;
    border-radius: 12px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.07);
    text-align: left;
}

#<?= $blockId ?> .form-group {
    margin-bottom: 20px;
}

#<?= $blockId ?> .form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .form-group input,
#<?= $blockId ?> .form-group textarea {
    width: 100%;
    padding: 12px;
    border: 1px solid var(--border-color, #e5e7eb);
    border-radius: 8px;
    font-size: 16px;
    box-sizing: border-box;
    transition: border-color 0.3s;
}

#<?= $blockId ?> .form-group input:focus,
#<?= $blockId ?> .form-group textarea:focus {
    outline: none;
    border-color: var(--primary-color, #667eea);
}

#<?= $blockId ?> .form-group textarea {
    resize: vertical;
}

#<?= $blockId ?> .btn-primary {
    padding: 15px 40px;
    border: none;
    border-radius: 8px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    width: 100%;
    background: var(--primary-color, #667eea);
    color: white;
    transition: all 0.3s;
}

#<?= $blockId ?> .btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(102, 126, 234, 0.3);
}

/* Tablet: 768px+ */
@media (min-width: 768px) {
    #<?= $blockId ?> h2 {
        font-size: 3rem;
    }
}
</style>