<?php
/** cms-core/public/webview/blocks/leistungen.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? ['text' => 'Unsere Leistungen'];
$services = $data['services'] ?? [];

$blockId = 'leistungen-' . uniqid();
?>

<section class="leistungen" id="<?= $blockId ?>">
    <div class="container">
        <?= render_richtext($title, 'h2') ?>
        <div class="services-grid">
            <?php foreach ($services as $service): ?>
                <div class="service-card">
                    <?php 
                    // Handle Icon OR Image with size
                    $iconType = $service['icon_type'] ?? 'emoji';
                    $iconValue = $service['icon'] ?? '';
                    $iconSize = $service['icon_size'] ?? 'medium-square';
                    
                    // Size mapping
                    $sizeMap = [
                        'small-square' => ['width' => '60px', 'height' => '60px'],
                        'medium-square' => ['width' => '80px', 'height' => '80px'],
                        'large-square' => ['width' => '120px', 'height' => '120px'],
                        'small-rect' => ['width' => '100px', 'height' => '60px'],
                        'medium-rect' => ['width' => '150px', 'height' => '90px'],
                        'large-rect' => ['width' => '200px', 'height' => '120px']
                    ];
                    
                    $dimensions = $sizeMap[$iconSize] ?? $sizeMap['medium-square'];
                    
                    if (!empty($iconValue)): ?>
                        <div class="service-icon">
                            <?php if ($iconType === 'image'): ?>
                                <img src="/media/pages/<?= e($iconValue) ?>" 
                                     alt="Service Icon" 
                                     style="width: <?= $dimensions['width'] ?>; height: <?= $dimensions['height'] ?>; object-fit: contain; border-radius: 8px;">
                            <?php else: ?>
                                <span style="font-size: 3rem;"><?= e($iconValue) ?></span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php
                    // Handle title (can be string or RichText array)
                    $serviceTitle = $service['title'] ?? '';
                    if (is_string($serviceTitle)) {
                        $decoded = json_decode($serviceTitle, true);
                        if (is_array($decoded)) {
                            echo render_richtext($decoded, 'h3');
                        } else {
                            echo '<h3>' . e($serviceTitle) . '</h3>';
                        }
                    } elseif (is_array($serviceTitle)) {
                        echo render_richtext($serviceTitle, 'h3');
                    }
                    ?>
                    
                    <?php
                    // Handle description (can be string or RichText array)
                    $serviceDesc = $service['description'] ?? '';
                    if (is_string($serviceDesc)) {
                        $decoded = json_decode($serviceDesc, true);
                        if (is_array($decoded)) {
                            echo render_richtext($decoded, 'p');
                        } else {
                            echo '<p>' . e($serviceDesc) . '</p>';
                        }
                    } elseif (is_array($serviceDesc)) {
                        echo render_richtext($serviceDesc, 'p');
                    }
                    ?>
                    
                    <?php if (!empty($service['button_link'])): ?>
                        <a href="/<?= e(str_replace('.php', '', $service['button_link'])) ?>" class="btn btn-primary">
                            <?= e($service['button_text'] ?? 'Mehr erfahren') ?>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
/* ===============================================
   LEISTUNGEN / SERVICES BLOCK
   =============================================== */

#<?= $blockId ?> {
    padding: 80px 20px;
}

#<?= $blockId ?> .container {
    max-width: 1200px;
    margin: 0 auto;
}

#<?= $blockId ?> h2 {
    text-align: center;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 60px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .services-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 30px;
}

#<?= $blockId ?> .service-card {
    background: var(--white, #ffffff);
    padding: 40px 30px;
    border-radius: 16px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.07);
    transition: all 0.3s ease;
    text-align: center;
}

#<?= $blockId ?> .service-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 24px rgba(0, 0, 0, 0.12);
}

#<?= $blockId ?> .service-icon {
    margin-bottom: 24px;
    display: flex;
    justify-content: center;
    align-items: center;
}

#<?= $blockId ?> .service-card h3 {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 15px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .service-card p {
    font-size: 1rem;
    line-height: 1.7;
    color: var(--text-light, #6b7280);
    margin-bottom: 20px;
}

#<?= $blockId ?> .service-card .btn {
    margin-top: 15px;
    display: inline-block;
}

#<?= $blockId ?> .btn-primary {
    background: var(--primary-color, #667eea);
    color: white;
    padding: 12px 30px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s;
}

#<?= $blockId ?> .btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(102, 126, 234, 0.3);
}

/* Tablet: 768px+ - 2 columns */
@media (min-width: 768px) {
    #<?= $blockId ?> .services-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 40px;
    }
}

/* Desktop: 1024px+ - 3 columns */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 100px 20px;
    }
    
    #<?= $blockId ?> .services-grid {
        grid-template-columns: repeat(3, 1fr);
    }
    
    #<?= $blockId ?> h2 {
        font-size: 3rem;
    }
}
</style>