<?php
/** cms-core/public/webview/blocks/mailchimp_block.php
 * CORE: Mailchimp Newsletter Signup Block
 * Part of cms-core system
 */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

return [
    'mailchimp_signup' => [
        'name' => 'Newsletter Anmeldung',
        'icon' => '📧',
        'description' => 'Mailchimp Newsletter-Anmeldung mit E-Mail-Feld',
        'fields' => [
            'title' => [
                'label' => 'Überschrift',
                'type' => 'text',
                'default' => 'Newsletter abonnieren',
                'required' => true
            ],
            'subtitle' => [
                'label' => 'Untertitel',
                'type' => 'textarea',
                'default' => 'Erhalten Sie die neuesten Updates und Angebote direkt in Ihr Postfach.'
            ],
            'button_text' => [
                'label' => 'Button-Text',
                'type' => 'text',
                'default' => 'Jetzt anmelden',
                'required' => true
            ],
            'success_message' => [
                'label' => 'Erfolgs-Nachricht',
                'type' => 'text',
                'default' => 'Vielen Dank! Bitte bestätigen Sie Ihre E-Mail-Adresse.'
            ],
            'show_privacy_checkbox' => [
                'label' => 'Datenschutz-Checkbox anzeigen',
                'type' => 'checkbox',
                'default' => true
            ],
            'privacy_text' => [
                'label' => 'Datenschutz-Text',
                'type' => 'textarea',
                'default' => 'Ich habe die Datenschutzerklärung gelesen und stimme zu.'
            ],
            'background_color' => [
                'label' => 'Hintergrundfarbe',
                'type' => 'text',
                'default' => '#f9fafb'
            ]
        ]
    ]
];