<?php
/** cms-core/public/webview/blocks/pricing.php */
// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? ['text' => 'Unsere Preise'];
$subtitle = $data['subtitle'] ?? '';
$plans = $data['plans'] ?? [];

if (empty($plans)) {
    return '';
}

$blockId = 'pricing-' . uniqid();
?>

<section class="pricing-section" id="<?= $blockId ?>">
    <div class="container">
        <div class="pricing-header">
            <?= render_richtext($title, 'h2') ?>
            <?php if (!empty($subtitle)): ?>
                <?= render_richtext($subtitle, 'p') ?>
            <?php endif; ?>
        </div>
        
        <div class="pricing-grid">
            <?php foreach ($plans as $plan): ?>
                <?php 
                $isHighlighted = $plan['highlighted'] ?? false;
                ?>
                <div class="pricing-card <?= $isHighlighted ? 'highlighted' : '' ?>">
                    <?php if ($isHighlighted && !empty($plan['badge'])): ?>
                        <div class="pricing-badge">
                            <?= render_richtext($plan['badge'], 'span') ?>
                        </div>
                    <?php endif; ?>
                    
                    <?= render_richtext($plan['name'] ?? '', 'h3') ?>
                    
                    <div class="pricing-price">
                        <?= render_richtext($plan['price'] ?? '', 'div') ?>
                        <?= render_richtext($plan['period'] ?? '', 'div') ?>
                    </div>
                    
                    <?php if (!empty($plan['features'])): ?>
                        <ul class="pricing-features">
                            <?php foreach ($plan['features'] as $feature): ?>
                                <li>✓ <?= e($feature) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                    
                    <?php if (!empty($plan['button_text'])): ?>
                        <a href="<?= e($plan['button_link'] ?? '#') ?>" class="btn pricing-btn">
                            <?= e($plan['button_text']) ?>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
/* ===============================================
   PRICING BLOCK
   =============================================== */

#<?= $blockId ?> {
    padding: 80px 20px;
}

#<?= $blockId ?> .container {
    max-width: 1200px;
    margin: 0 auto;
}

#<?= $blockId ?> .pricing-header {
    text-align: center;
    margin-bottom: 60px;
}

#<?= $blockId ?> h2 {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 15px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .pricing-header p {
    font-size: 1.125rem;
    color: var(--text-light, #6b7280);
}

#<?= $blockId ?> .pricing-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 30px;
}

#<?= $blockId ?> .pricing-card {
    background: var(--white, #ffffff);
    border: 2px solid var(--border-color, #e5e7eb);
    border-radius: 16px;
    padding: 40px 30px;
    text-align: center;
    position: relative;
    transition: all 0.3s;
}

#<?= $blockId ?> .pricing-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
}

#<?= $blockId ?> .pricing-card.highlighted {
    border-color: var(--primary-color, #667eea);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.2);
    transform: scale(1.05);
}

#<?= $blockId ?> .pricing-card.highlighted:hover {
    transform: scale(1.05) translateY(-5px);
}

#<?= $blockId ?> .pricing-badge {
    position: absolute;
    top: -15px;
    left: 50%;
    transform: translateX(-50%);
    background: linear-gradient(135deg, var(--primary-color, #667eea) 0%, var(--secondary-color, #764ba2) 100%);
    color: white;
    padding: 6px 20px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 600;
}

#<?= $blockId ?> .pricing-card h3 {
    font-size: 1.75rem;
    font-weight: 700;
    margin-bottom: 20px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .pricing-price {
    margin-bottom: 30px;
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--primary-color, #667eea);
}

#<?= $blockId ?> .pricing-features {
    list-style: none;
    padding: 0;
    margin: 0 0 30px 0;
    text-align: left;
}

#<?= $blockId ?> .pricing-features li {
    padding: 12px 0;
    border-bottom: 1px solid var(--border-color, #e5e7eb);
    font-size: 15px;
    color: var(--text-light, #4b5563);
}

#<?= $blockId ?> .pricing-btn {
    display: block;
    padding: 12px 30px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s;
    background: var(--border-color, #e5e7eb);
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .pricing-card.highlighted .pricing-btn {
    background: var(--primary-color, #667eea);
    color: white;
}

#<?= $blockId ?> .pricing-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

/* Tablet: 768px+ - 2 columns */
@media (min-width: 768px) {
    #<?= $blockId ?> .pricing-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

/* Desktop: 1024px+ - 3 columns */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 100px 20px;
    }
    
    #<?= $blockId ?> .pricing-grid {
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    }
    
    #<?= $blockId ?> h2 {
        font-size: 3rem;
    }
}
</style>