<?php
/**
 * cms-core/public/webview/blocks/recent_blog_posts.php
 * Block: Recent Blog Posts (Last 3 posts)
 * CORRECTED LOCATION: This goes in public/webview/blocks/
 */
// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

return [
    'name' => 'Neueste Blog-Beiträge',
    'icon' => '📝',
    'category' => 'content',
    'fields' => [
        'title' => [
            'type' => 'text',
            'label' => 'Überschrift',
            'default' => 'Neueste Beiträge'
        ],
        'subtitle' => [
            'type' => 'text',
            'label' => 'Untertitel',
            'default' => 'Bleiben Sie auf dem Laufenden'
        ],
        'show_button' => [
            'type' => 'checkbox',
            'label' => 'Button "Alle anzeigen" anzeigen',
            'default' => true
        ],
        'button_text' => [
            'type' => 'text',
            'label' => 'Button-Text',
            'default' => 'Alle Beiträge anzeigen'
        ],
        'posts_count' => [
            'type' => 'select',
            'label' => 'Anzahl Beiträge',
            'options' => [
                '3' => '3 Beiträge',
                '6' => '6 Beiträge',
                '9' => '9 Beiträge'
            ],
            'default' => '3'
        ]
    ],
    'render' => function($data) {
        // Check if blog is enabled
        if (!get_setting('blog_enabled', true)) {
            return '<div style="padding: 20px; background: #fee; border: 2px dashed #fcc; text-align: center;">⚠️ Blog ist deaktiviert</div>';
        }
        
        $title = $data['title'] ?? 'Neueste Beiträge';
        $subtitle = $data['subtitle'] ?? 'Bleiben Sie auf dem Laufenden';
        $showButton = $data['show_button'] ?? true;
        $buttonText = $data['button_text'] ?? 'Alle Beiträge anzeigen';
        $postsCount = (int)($data['posts_count'] ?? 3);
        
        // Get recent published blog posts
        $posts = db()->fetchAll(
            "SELECT * FROM blog_posts 
             WHERE status = 'published' 
             ORDER BY published_at DESC 
             LIMIT ?",
            [$postsCount]
        );
        
        if (empty($posts)) {
            return '<div style="padding: 40px; text-align: center; background: #f9fafb; border-radius: 12px;">
                        <div style="font-size: 48px; opacity: 0.3; margin-bottom: 10px;">📝</div>
                        <p style="color: #9ca3af;">Noch keine Blog-Beiträge vorhanden.</p>
                    </div>';
        }
        
        ob_start();
        ?>
        <section class="recent-blog-posts-block" style="padding: 4rem 0; background: #f9fafb;">
            <div class="container">
                <div style="text-align: center; margin-bottom: 3rem;">
                    <h2 style="font-size: 2.5rem; margin-bottom: 1rem; color: #1f2937;"><?= e($title) ?></h2>
                    <?php if ($subtitle): ?>
                        <p style="font-size: 1.2rem; color: #6b7280;"><?= e($subtitle) ?></p>
                    <?php endif; ?>
                </div>
                
                <div class="blog-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: <?= $showButton ? '3rem' : '0' ?>;">
                    <?php foreach ($posts as $post): ?>
                        <article class="blog-card" style="background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 8px rgba(0,0,0,0.08); transition: transform 0.3s, box-shadow 0.3s; cursor: pointer;" 
                                 onclick="window.location.href='/blog/<?= e($post['slug']) ?>'"
                                 onmouseover="this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 16px rgba(0,0,0,0.12)'"
                                 onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.08)'">
                            
                            <?php if ($post['featured_image']): ?>
                                <div class="blog-image" style="height: 200px; background-image: url('/media/blog/<?= e($post['featured_image']) ?>'); background-size: cover; background-position: center;"></div>
                            <?php else: ?>
                                <div class="blog-image" style="height: 200px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center;">
                                    <span style="font-size: 64px; opacity: 0.5;">📝</span>
                                </div>
                            <?php endif; ?>
                            
                            <div style="padding: 24px;">
                                <div style="font-size: 13px; color: #9ca3af; margin-bottom: 8px;">
                                    📅 <?= date('d.m.Y', strtotime($post['published_at'])) ?>
                                </div>
                                
                                <h3 style="font-size: 1.3rem; margin-bottom: 12px; color: #1f2937; line-height: 1.3;">
                                    <?= e($post['title']) ?>
                                </h3>
                                
                                <?php if ($post['excerpt']): ?>
                                    <p style="color: #6b7280; line-height: 1.6; margin-bottom: 16px; font-size: 0.95rem;">
                                        <?= e(substr($post['excerpt'], 0, 100)) ?><?= strlen($post['excerpt']) > 100 ? '...' : '' ?>
                                    </p>
                                <?php endif; ?>
                                
                                <a href="/blog/<?= e($post['slug']) ?>" 
                                   class="read-more" 
                                   style="display: inline-block; color: #667eea; font-weight: 600; text-decoration: none; font-size: 0.95rem;"
                                   onclick="event.stopPropagation()">
                                    Weiterlesen →
                                </a>
                            </div>
                        </article>
                    <?php endforeach; ?>
                </div>
                
                <?php if ($showButton): ?>
                    <div style="text-align: center;">
                        <a href="/blog" 
                           class="btn btn-primary" 
                           style="display: inline-block; padding: 14px 32px; background: linear-gradient(135deg, #667eea, #764ba2); color: white; text-decoration: none; border-radius: 8px; font-weight: 600; transition: transform 0.3s, box-shadow 0.3s;"
                           onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 8px 16px rgba(102,126,234,0.4)'"
                           onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <?= e($buttonText) ?> →
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
        return ob_get_clean();
    }
];