<?php
/**
 * cms-core/public/webview/blocks/spacer_block.php
 * Spacer Block - Adds vertical spacing between blocks
 */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$height = $data['height'] ?? 'medium';
$showLine = !empty($data['show_line']);

// Map height values to pixels
$heightMap = [
    'small' => '20px',
    'medium' => '40px',
    'large' => '60px',
    'xlarge' => '80px',
    'xxlarge' => '120px'
];

$heightPx = $heightMap[$height] ?? '40px';
?>

<div class="spacer-block" style="height: <?= $heightPx ?>; position: relative; <?= $showLine ? 'display: flex; align-items: center;' : '' ?>">
    <?php if ($showLine): ?>
        <div class="spacer-line" style="width: 100%; height: 1px; background: var(--border-color, #e5e7eb);"></div>
    <?php endif; ?>
</div>