<?php
/** cms-core/public/webview/blocks/testimonials.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? ['text' => 'Was unsere Kunden sagen'];
$testimonials = $data['testimonials'] ?? [];

if (empty($testimonials)) {
    return '';
}

$blockId = 'testimonials-' . uniqid();
?>

<section class="testimonials-section" id="<?= $blockId ?>">
    <div class="container">
        <?= render_richtext($title, 'h2') ?>
        
        <div class="testimonials-grid">
            <?php foreach ($testimonials as $testimonial): ?>
                <div class="testimonial-card">
                    <!-- Rating Stars -->
                    <div class="testimonial-rating">
                        <?php 
                        $rating = (int)($testimonial['rating'] ?? 5);
                        for ($i = 0; $i < 5; $i++) {
                            echo $i < $rating ? '⭐' : '☆';
                        }
                        ?>
                    </div>
                    
                    <!-- Testimonial Text -->
                    <p class="testimonial-text">
                        "<?= e($testimonial['text'] ?? '') ?>"
                    </p>
                    
                    <!-- Author -->
                    <div class="testimonial-author">
                        <?php if (!empty($testimonial['image'])): ?>
                            <?php 
                            $imagePath = $testimonial['image'];
                            if (!str_starts_with($imagePath, 'http')) {
                                $imagePath = '/media/pages/' . $imagePath;
                            }
                            ?>
                            <img src="<?= e($imagePath) ?>" alt="<?= e($testimonial['name'] ?? '') ?>">
                        <?php else: ?>
                            <div class="testimonial-avatar">
                                <?= strtoupper(substr($testimonial['name'] ?? 'A', 0, 1)) ?>
                            </div>
                        <?php endif; ?>
                        <div class="testimonial-name">
                            <?= e($testimonial['name'] ?? '') ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
/* ===============================================
   TESTIMONIALS BLOCK
   =============================================== */

#<?= $blockId ?> {
    padding: 80px 20px;
}

#<?= $blockId ?> .container {
    max-width: 1200px;
    margin: 0 auto;
}

#<?= $blockId ?> h2 {
    text-align: center;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 60px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .testimonials-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 30px;
}

#<?= $blockId ?> .testimonial-card {
    background: var(--white, #ffffff);
    padding: 30px;
    border-radius: 16px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.07);
    position: relative;
    transition: all 0.3s;
}

#<?= $blockId ?> .testimonial-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 12px rgba(0, 0, 0, 0.1);
}

#<?= $blockId ?> .testimonial-rating {
    margin-bottom: 20px;
    font-size: 24px;
}

#<?= $blockId ?> .testimonial-text {
    line-height: 1.8;
    margin-bottom: 24px;
    font-style: italic;
    color: var(--text-light, #4b5563);
}

#<?= $blockId ?> .testimonial-author {
    display: flex;
    align-items: center;
    gap: 16px;
}

#<?= $blockId ?> .testimonial-author img {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    object-fit: cover;
}

#<?= $blockId ?> .testimonial-avatar {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: var(--primary-color, #667eea);
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 20px;
    color: white;
}

#<?= $blockId ?> .testimonial-name {
    font-weight: 600;
    font-size: 16px;
    color: var(--text-dark, #1f2937);
}

/* Tablet: 768px+ - 2 columns */
@media (min-width: 768px) {
    #<?= $blockId ?> .testimonials-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

/* Desktop: 1024px+ - 3 columns */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 100px 20px;
    }
    
    #<?= $blockId ?> .testimonials-grid {
        grid-template-columns: repeat(3, 1fr);
    }
    
    #<?= $blockId ?> h2 {
        font-size: 3rem;
    }
}
</style>