<?php
/** cms-core/public/webview/blocks/text_block.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? '';
$text = $data['text'] ?? '';

if (empty($title) && empty($text)) {
    return '';
}

$blockId = 'text-' . uniqid();
?>

<section class="text-block" id="<?= $blockId ?>">
    <div class="container">
        <?php if (!empty($title)): ?>
            <?php 
            if (is_array($title)) {
                echo render_richtext($title, 'h2');
            } else {
                echo '<h2>' . e($title) . '</h2>';
            }
            ?>
        <?php endif; ?>
        
        <?php if (!empty($text)): ?>
            <div class="text-content">
                <?php 
                if (is_array($text)) {
                    echo render_richtext($text, 'div');
                } else {
                    echo '<div>' . nl2br(e($text)) . '</div>';
                }
                ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<style>
/* ===============================================
   TEXT BLOCK
   =============================================== */

#<?= $blockId ?> {
    padding: 60px 20px;
}

#<?= $blockId ?> .container {
    max-width: 900px;
    margin: 0 auto;
    text-align: center;
}

#<?= $blockId ?> h2 {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 20px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .text-content {
    line-height: 1.8;
    font-size: 18px;
    color: var(--text-light, #4b5563);
}

#<?= $blockId ?> .text-content p {
    margin-bottom: 1rem;
}

/* Tablet: 768px+ */
@media (min-width: 768px) {
    #<?= $blockId ?> {
        padding: 80px 20px;
    }
    
    #<?= $blockId ?> h2 {
        font-size: 2.5rem;
    }
}

/* Desktop: 1024px+ */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 100px 20px;
    }
}
</style>