<?php
/** cms-core/public/webview/blocks/two_column_image_left.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}
// Color support
$titleColor = $data['title_color'] ?? 'var(--color-title, #1f2937)';
$textColor = $data['text_color'] ?? 'var(--color-text, #4b5563)';
$bgColor = $data['bg_color'] ?? 'var(--color-bg, #ffffff)';

$title = $data['title'] ?? '';
$text = $data['text'] ?? $data['content'] ?? '';
$image = $data['image'] ?? '';

$blockId = 'two-col-left-' . uniqid();
?>

<section class="two-column-section" id="<?= $blockId ?>" style="background: <?= e($bgColor) ?>;">
    <div class="container">
        <div class="two-column-grid">
            <!-- Image Left -->
            <div class="column-image">
                <?php if ($image): ?>
                    <img src="/media.php?file=pages/<?= e($image) ?>" 
                         alt="<?= e($title) ?>"
                         class="image-content"
                         loading="lazy">
                <?php else: ?>
                    <div class="image-placeholder">
                        <svg width="64" height="64" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M6.002 5.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z"/>
                            <path d="M2.002 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2h-12zm12 1a1 1 0 0 1 1 1v6.5l-3.777-1.947a.5.5 0 0 0-.577.093l-3.71 3.71-2.66-1.772a.5.5 0 0 0-.63.062L1.002 12V3a1 1 0 0 1 1-1h12z"/>
                        </svg>
                        <p>Bild hier</p>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Text Right -->
            <div class="column-text">
                <?php if ($title): ?>
                    <h2 class="column-title" style="color: <?= e($titleColor) ?>;">
                        <?= e($title) ?>
                    </h2>
                <?php endif; ?>
                
                <?php if ($text): ?>
                    <div class="column-content" style="color: <?= e($textColor) ?>;">
                        <?= nl2br(e($text)) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<style>
/* ===============================================
   TWO COLUMN IMAGE LEFT - SELF-CONTAINED STYLES
   =============================================== */

#<?= $blockId ?> {
    padding: 4rem 0;
}

#<?= $blockId ?> .two-column-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 2rem;
    align-items: center;
}

#<?= $blockId ?> .column-image {
    order: 1;
}

#<?= $blockId ?> .column-text {
    order: 2;
}

#<?= $blockId ?> .column-title {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    line-height: 1.3;
}

#<?= $blockId ?> .column-content {
    font-size: 1.125rem;
    line-height: 1.8;
}

#<?= $blockId ?> .image-content {
    width: 100%;
    height: auto;
    border-radius: 16px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
}

#<?= $blockId ?> .image-placeholder {
    width: 100%;
    min-height: 400px;
    background: #f3f4f6;
    border-radius: 16px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    color: #9ca3af;
    gap: 1rem;
}

#<?= $blockId ?> .image-placeholder p {
    margin: 0;
}

/* Tablet: 768px+ */
@media (min-width: 768px) {
    #<?= $blockId ?> .two-column-grid {
        grid-template-columns: 1fr 1fr;
        gap: 3rem;
    }
    
    #<?= $blockId ?> .column-image {
        order: 1;
    }
    
    #<?= $blockId ?> .column-text {
        order: 2;
    }
    
    #<?= $blockId ?> .column-title {
        font-size: 2.5rem;
    }
}

/* Desktop: 1024px+ */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 5rem 0;
    }
    
    #<?= $blockId ?> .two-column-grid {
        gap: 4rem;
    }
}
</style>