<?php
/** cms-core/public/webview/blocks/two_column_image_right.php */

// Prevent rendering in admin pages EXCEPT visual editor
if (isset($_SERVER['REQUEST_URI']) && 
    strpos($_SERVER['REQUEST_URI'], '/admin/') !== false && 
    strpos($_SERVER['REQUEST_URI'], 'page_visual_edit.php') === false) {
    return;
}

$title = $data['title'] ?? '';
$text = $data['text'] ?? '';
$image = $data['image'] ?? '';

if ($image && !str_starts_with($image, 'http')) {
    $image = '/media/pages/' . $image;
}

$blockId = 'twocol-right-' . uniqid();
?>

<section class="two-column-image-right" id="<?= $blockId ?>">
    <div class="container">
        <div class="two-col-grid">
            <div class="col-text">
                <?= render_richtext($title, 'h2') ?>
                <div class="text-content">
                    <?= render_richtext($text, 'div') ?>
                </div>
            </div>
            <div class="col-image">
                <?php if ($image): ?>
                    <img src="<?= e($image) ?>" alt="<?= get_richtext_plain($title) ?>">
                <?php else: ?>
                    <div class="image-placeholder">
                        Bild hier
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<style>
/* ===============================================
   TWO COLUMN - IMAGE RIGHT
   =============================================== */

#<?= $blockId ?> {
    padding: 80px 20px;
}

#<?= $blockId ?> .container {
    max-width: 1200px;
    margin: 0 auto;
}

#<?= $blockId ?> .two-col-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 40px;
    align-items: center;
}

#<?= $blockId ?> h2 {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 20px;
    color: var(--text-dark, #1f2937);
}

#<?= $blockId ?> .text-content {
    line-height: 1.8;
    font-size: 16px;
    color: var(--text-light, #4b5563);
}

#<?= $blockId ?> .col-image img {
    width: 100%;
    border-radius: 12px;
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
}

#<?= $blockId ?> .image-placeholder {
    width: 100%;
    height: 400px;
    border-radius: 12px;
    background: var(--bg-light, #f3f4f6);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--text-light, #9ca3af);
    font-size: 18px;
}

/* Tablet: 768px+ */
@media (min-width: 768px) {
    #<?= $blockId ?> .two-col-grid {
        grid-template-columns: 1fr 1fr;
        gap: 60px;
    }
    
    #<?= $blockId ?> h2 {
        font-size: 2.5rem;
    }
}

/* Desktop: 1024px+ */
@media (min-width: 1024px) {
    #<?= $blockId ?> {
        padding: 100px 20px;
    }
}
</style>