<?php
/** cms-core/public/webview/blog.php */

require_once __DIR__ . '/../../backend/core/init.php';

// Pagination
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$perPage = 9;
$offset = ($page - 1) * $perPage;

// Get total count
$totalPosts = db()->fetchOne(
    "SELECT COUNT(*) as count FROM blog_posts WHERE status = 'published'"
)['count'];

$totalPages = ceil($totalPosts / $perPage);

// Get posts for current page
$posts = db()->fetchAll(
    "SELECT bp.*, u.username as author_name 
     FROM blog_posts bp 
     LEFT JOIN users u ON bp.author_id = u.id 
     WHERE bp.status = 'published' 
     ORDER BY bp.published_at DESC 
     LIMIT ? OFFSET ?",
    [$perPage, $offset]
);

$pageTitle = 'Blog';
$metaDescription = 'Entdecken Sie unsere neuesten Artikel und Insights.';
$bodyClass = 'page-blog';

ob_start();
?>

<!-- MODERN BLOG LISTING -->
<div class="modern-blog-listing">
    <!-- Hero Header -->
    <section class="blog-hero">
        <div class="container">
            <div class="blog-hero-content">
                <h1 class="blog-hero-title">📚 Unser Blog</h1>
                <p class="blog-hero-subtitle">
                    Entdecken Sie Insights, Tipps und Geschichten rund um Kynologie und Psychologie
                </p>
            </div>
        </div>
    </section>
    
    <!-- Blog Grid -->
    <section class="blog-grid-section">
        <div class="container">
            <?php if (empty($posts)): ?>
                <!-- Empty State -->
                <div class="empty-state-modern">
                    <div class="empty-icon">✍️</div>
                    <h2>Noch keine Artikel</h2>
                    <p>Bald finden Sie hier spannende Inhalte!</p>
                </div>
            <?php else: ?>
                <!-- Posts Grid -->
                <div class="posts-grid-modern">
                    <?php foreach ($posts as $index => $post): ?>
                        <article class="post-card-modern <?= $index === 0 ? 'featured-post' : '' ?>">
                            <a href="<?= blog_post_url($post['slug']) ?>" class="post-card-link">
                                <!-- Image -->
                                <div class="post-card-image">
                                    <?php if ($post['featured_image']): ?>
                                        <img src="<?= media_url('blog/' . e($post['featured_image'])) ?>" 
                                             alt="<?= e($post['title']) ?>"
                                             loading="lazy">
                                    <?php else: ?>
                                        <div class="post-card-placeholder">
                                            <svg width="64" height="64" fill="currentColor" viewBox="0 0 16 16">
                                                <path d="M5.5 7a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5zM5 9.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5z"/>
                                                <path d="M9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.5L9.5 0zm0 1v2A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5z"/>
                                            </svg>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <!-- Overlay Badge (Featured Post Only) -->
                                    <?php if ($index === 0): ?>
                                        <div class="featured-badge">
                                            ⭐ Neuester Artikel
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Content -->
                                <div class="post-card-content">
                                    <!-- Meta -->
                                    <div class="post-card-meta">
                                        <span class="meta-date">
                                            <svg width="14" height="14" fill="currentColor" viewBox="0 0 16 16">
                                                <path d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71V3.5z"/>
                                                <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0z"/>
                                            </svg>
                                            <?= format_date($post['published_at'], 'd. M Y') ?>
                                        </span>
                                    </div>
                                    
                                    <!-- Title -->
                                    <h2 class="post-card-title">
                                        <?= e($post['title']) ?>
                                    </h2>
                                    
                                    <!-- Excerpt -->
                                    <?php if ($post['excerpt']): ?>
                                        <p class="post-card-excerpt">
                                            <?= e(truncate($post['excerpt'], $index === 0 ? 200 : 120)) ?>
                                        </p>
                                    <?php endif; ?>
                                    
                                    <!-- Read More -->
                                    <div class="post-card-footer">
                                        <span class="read-more-link">
                                            Weiterlesen
                                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </a>
                        </article>
                    <?php endforeach; ?>
                </div>
                
                <!-- Pagination -->
                <?php if ($totalPages > 1): ?>
                    <div class="pagination-modern">
                        <?php if ($page > 1): ?>
                            <a href="<?= blog_url() ?>?page=<?= $page - 1 ?>" class="pagination-btn pagination-prev">
                                <svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
                                </svg>
                                Vorherige
                            </a>
                        <?php endif; ?>
                        
                        <div class="pagination-numbers">
                            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                                <?php if ($i === $page): ?>
                                    <span class="pagination-number active"><?= $i ?></span>
                                <?php else: ?>
                                    <a href="<?= blog_url() ?>?page=<?= $i ?>" class="pagination-number"><?= $i ?></a>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </div>
                        
                        <?php if ($page < $totalPages): ?>
                            <a href="<?= blog_url() ?>?page=<?= $page + 1 ?>" class="pagination-btn pagination-next">
                                Nächste
                                <svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </section>
</div>

<!-- STYLES (same as before) -->
<style>
/* [Keep all existing styles from original blog.php] */
.modern-blog-listing {
    background: #f9fafb;
    min-height: 80vh;
}

/* Blog Hero */
.blog-hero {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 5rem 0 4rem;
    text-align: center;
    position: relative;
    overflow: hidden;
}

.blog-hero::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"><g fill="none" fill-rule="evenodd"><g fill="%23ffffff" fill-opacity="0.05"><path d="M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z"/></g></g></svg>');
    opacity: 0.3;
}

.blog-hero-content {
    position: relative;
    z-index: 1;
}

.blog-hero-title {
    font-size: 4rem;
    font-weight: 900;
    color: white;
    margin-bottom: 1rem;
    text-shadow: 0 2px 20px rgba(0, 0, 0, 0.2);
}

.blog-hero-subtitle {
    font-size: 1.5rem;
    color: rgba(255, 255, 255, 0.95);
    max-width: 700px;
    margin: 0 auto;
    line-height: 1.6;
}

/* Blog Grid Section */
.blog-grid-section {
    padding: 4rem 0;
}

.posts-grid-modern {
    display: grid;
    grid-template-columns: 1fr;
    gap: 2.5rem;
}

/* Post Card */
.post-card-modern {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    border: 1px solid #e5e7eb;
}

.post-card-modern:hover {
    transform: translateY(-12px);
    box-shadow: 0 20px 50px rgba(0, 0, 0, 0.15);
}

.post-card-link {
    text-decoration: none;
    color: inherit;
    display: block;
}

/* Featured Post (First Post) */
.featured-post {
    grid-column: 1 / -1;
}

.featured-post .post-card-image {
    height: 400px;
}

.featured-post .post-card-title {
    font-size: 2.5rem;
}

/* Card Image */
.post-card-image {
    position: relative;
    height: 280px;
    overflow: hidden;
    background: #f3f4f6;
}

.post-card-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.4s ease;
}

.post-card-modern:hover .post-card-image img {
    transform: scale(1.08);
}

.post-card-placeholder {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f3f4f6 0%, #e5e7eb 100%);
    color: #9ca3af;
}

.featured-badge {
    position: absolute;
    top: 20px;
    left: 20px;
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 700;
    color: #667eea;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

/* Card Content */
.post-card-content {
    padding: 2rem;
}

.post-card-meta {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1rem;
}

.meta-date {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    font-size: 14px;
    color: #6b7280;
    font-weight: 500;
}

.post-card-title {
    font-size: 1.75rem;
    font-weight: 800;
    color: #111827;
    margin-bottom: 1rem;
    line-height: 1.3;
    transition: color 0.3s ease;
}

.post-card-modern:hover .post-card-title {
    color: #667eea;
}

.post-card-excerpt {
    color: #6b7280;
    font-size: 1rem;
    line-height: 1.7;
    margin-bottom: 1.5rem;
}

.post-card-footer {
    padding-top: 1rem;
    border-top: 1px solid #e5e7eb;
}

.read-more-link {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: #667eea;
    font-weight: 700;
    font-size: 15px;
    transition: gap 0.3s ease;
}

.post-card-modern:hover .read-more-link {
    gap: 12px;
}

/* Empty State */
.empty-state-modern {
    text-align: center;
    padding: 6rem 2rem;
}

.empty-icon {
    font-size: 6rem;
    margin-bottom: 1.5rem;
    opacity: 0.8;
}

.empty-state-modern h2 {
    font-size: 2rem;
    font-weight: 800;
    color: #111827;
    margin-bottom: 1rem;
}

.empty-state-modern p {
    font-size: 1.125rem;
    color: #6b7280;
}

/* Pagination */
.pagination-modern {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 1rem;
    margin-top: 4rem;
    flex-wrap: wrap;
}

.pagination-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    background: white;
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    color: #374151;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
}

.pagination-btn:hover {
    border-color: #667eea;
    color: #667eea;
    transform: translateY(-2px);
}

.pagination-numbers {
    display: flex;
    gap: 8px;
}

.pagination-number {
    width: 44px;
    height: 44px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 12px;
    background: white;
    border: 2px solid #e5e7eb;
    color: #374151;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
}

.pagination-number:hover {
    border-color: #667eea;
    color: #667eea;
}

.pagination-number.active {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-color: transparent;
    color: white;
}

/* Tablet */
@media (min-width: 768px) {
    .posts-grid-modern {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .blog-hero-title {
        font-size: 4.5rem;
    }
}

/* Desktop */
@media (min-width: 1024px) {
    .posts-grid-modern {
        grid-template-columns: repeat(3, 1fr);
    }
    
    .featured-post {
        grid-column: span 2;
        display: grid;
        grid-template-columns: 1fr 1fr;
    }
    
    .featured-post .post-card-image {
        height: 100%;
    }
    
    .featured-post .post-card-content {
        display: flex;
        flex-direction: column;
        justify-content: center;
        padding: 3rem;
    }
}

/* Mobile */
@media (max-width: 767px) {
    .blog-hero {
        padding: 3rem 0 2rem;
    }
    
    .blog-hero-title {
        font-size: 2.5rem;
    }
    
    .blog-hero-subtitle {
        font-size: 1.125rem;
    }
    
    .post-card-image {
        height: 220px;
    }
    
    .featured-post .post-card-image {
        height: 250px;
    }
    
    .post-card-title {
        font-size: 1.5rem;
    }
    
    .featured-post .post-card-title {
        font-size: 1.75rem;
    }
}
</style>

<?php
$pageContent = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>