<?php
/** cms-core/public/webview/includes/footer.php - FIXED: Blog toggle */

require_once __DIR__ . '/../../../backend/settings/site_info_manager.php';
require_once __DIR__ . '/../../../backend/core/LegalPagesManager.php';

// Get footer configuration
$footerConfig = SiteInfoManager::getFooterConfig();
$socialLinks = SiteInfoManager::getSocialLinks();
$legalPages = LegalPagesManager::getAllLegalPages();
$siteName = get_setting('site_name', 'KynoCanis');
$logoInfo = SiteInfoManager::getLogoInfo();

// FIXED: Check if blog is enabled
$blogEnabled = get_setting('blog_enabled', true);
?>
<footer class="site-footer">
    <div class="container">
        <div class="footer-grid">
            <!-- Company Info -->
            <div class="footer-column">
                <div class="footer-branding">
                    <?php if ($logoInfo['use_logo'] && !empty($logoInfo['logo_path'])): ?>
                        <img src="/media.php?file=<?= e($logoInfo['logo_path']) ?>" 
                             alt="<?= e($siteName) ?>" 
                             class="footer-logo">
                    <?php else: ?>
                        <h3 class="footer-title"><?= e($siteName) ?></h3>
                    <?php endif; ?>
                </div>
                
                <?php if (!empty($footerConfig['description'])): ?>
                    <p class="footer-description">
                        <?= e($footerConfig['description']) ?>
                    </p>
                <?php endif; ?>
                
                <?php if ($footerConfig['show_address'] && !empty($footerConfig['address_line1'])): ?>
                    <div class="footer-contact">
                        <p class="contact-item">
                            <strong>📍 Adresse:</strong><br>
                            <?= e($footerConfig['address_line1']) ?><br>
                            <?= e($footerConfig['address_line2']) ?>
                        </p>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Contact Info -->
            <div class="footer-column">
                <h4 class="footer-heading">Kontakt</h4>
                <ul class="footer-links">
                    <?php if (!empty($footerConfig['email'])): ?>
                        <li>
                            <a href="mailto:<?= e($footerConfig['email']) ?>">
                                📧 <?= e($footerConfig['email']) ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (!empty($footerConfig['phone'])): ?>
                        <li>
                            <a href="tel:<?= preg_replace('/[^0-9+]/', '', $footerConfig['phone']) ?>">
                                📞 <?= e($footerConfig['phone']) ?>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
                
                <?php if (!empty($socialLinks)): ?>
                    <div class="social-links">
                        <h4 class="footer-heading">Folgen Sie uns</h4>
                        <div class="social-icons">
                            <?php foreach ($socialLinks as $platform => $link): ?>
                                <a href="<?= e($link['url']) ?>" 
                                   target="_blank" 
                                   rel="noopener noreferrer"
                                   class="social-icon"
                                   title="<?= e($link['label']) ?>">
                                    <span class="icon"><?= $link['icon'] ?></span>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Legal Pages + Blog -->
            <div class="footer-column">
                <h4 class="footer-heading">Links</h4>
                <ul class="footer-links">
                    <!-- FIXED: Blog link - only if enabled -->
                    <?php if ($blogEnabled): ?>
                        <li>
                            <a href="/blog">Blog</a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (!empty($legalPages)): ?>
                        <?php foreach ($legalPages as $page): ?>
                            <li>
                                <a href="/<?= e($page['slug']) ?>">
                                    <?= e($page['title']) ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
        
        <!-- Footer Bottom -->
        <div class="footer-bottom">
            <p class="copyright">
                © <?= date('Y') ?> <?= e($siteName) ?>. Alle Rechte vorbehalten.
            </p>
            <?php if (is_logged_in() && is_admin()): ?>
                <a href="/cms-core/public/webview/admin/dashboard.php" class="admin-link">
                    ⚙️ Admin
                </a>
            <?php endif; ?>
        </div>
    </div>
</footer>

<style>
/* Footer Styles */
.site-footer {
    background-color: var(--global-footer-bg-color, #1a202c);
    color: var(--global-footer-text-color, #ffffff);
    padding: 3rem 0 1rem 0;
    margin-top: 4rem;
}

.footer-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
    margin-bottom: 2rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.footer-column {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

/* Branding */
.footer-branding {
    margin-bottom: 0.5rem;
}

.footer-logo {
    max-height: 50px;
    height: auto;
    width: auto;
    max-width: 180px;
    object-fit: contain;
}

.footer-title {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0;
    color: var(--global-footer-text-color, #ffffff);
}

.footer-description {
    font-size: 0.9rem;
    line-height: 1.6;
    opacity: 0.9;
    margin: 0;
}

/* Contact Info */
.footer-contact {
    margin-top: 0.5rem;
}

.contact-item {
    font-size: 0.9rem;
    line-height: 1.6;
    margin: 0.5rem 0;
    opacity: 0.9;
}

.contact-item strong {
    display: block;
    margin-bottom: 0.25rem;
    opacity: 1;
}

/* Headings */
.footer-heading {
    font-size: 1.1rem;
    font-weight: 600;
    margin: 0 0 0.75rem 0;
    color: var(--global-footer-text-color, #ffffff);
}

/* Links */
.footer-links {
    list-style: none;
    padding: 0;
    margin: 0;
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.footer-links a {
    color: var(--global-footer-text-color, #ffffff);
    text-decoration: none;
    opacity: 0.85;
    transition: all 0.2s;
    font-size: 0.95rem;
}

.footer-links a:hover {
    opacity: 1;
    color: var(--global-link-hover-color, #a3bffa);
    transform: translateX(3px);
}

/* Social Links */
.social-links {
    margin-top: 1rem;
}

.social-icons {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.social-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
    text-decoration: none;
    transition: all 0.2s;
    font-size: 1.2rem;
}

.social-icon:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
}

.social-icon .icon {
    filter: grayscale(0);
}

/* Footer Bottom */
.footer-bottom {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 1.5rem;
    font-size: 0.9rem;
    opacity: 0.8;
    flex-wrap: wrap;
    gap: 1rem;
}

.copyright {
    margin: 0;
}

.admin-link {
    color: var(--global-footer-text-color, #ffffff);
    text-decoration: none;
    opacity: 0.7;
    transition: opacity 0.2s;
    font-size: 0.85rem;
}

.admin-link:hover {
    opacity: 1;
}

/* Responsive */
@media (max-width: 768px) {
    .site-footer {
        padding: 2rem 0 1rem 0;
        margin-top: 3rem;
    }
    
    .footer-grid {
        grid-template-columns: 1fr;
        gap: 2rem;
    }
    
    .footer-bottom {
        flex-direction: column;
        text-align: center;
        gap: 0.5rem;
    }
}
</style>