<?php
/** 
 * cms-core/public/webview/includes/layout.php
 * Main layout wrapper with dynamic favicon support
 */

// Load Integration Helper and integration files
require_once __DIR__ . '/../../../backend/integrations/integration_helper.php';
require_once __DIR__ . '/../../../backend/integrations/cookie_consent.php';
require_once __DIR__ . '/../../../backend/integrations/google_analytics.php';
require_once __DIR__ . '/../../../backend/integrations/tiktok_pixel.php';
require_once __DIR__ . '/../../../backend/integrations/instagram_pixel.php';

// Track pageview (DSGVO-compliant, no cookies)
if (file_exists(__DIR__ . '/../../../backend/analytics/AnalyticsTracker.php')) {
    require_once __DIR__ . '/../../../backend/analytics/AnalyticsTracker.php';
    AnalyticsTracker::trackPageview();
}

$pageTitle = $pageTitle ?? 'KynoCanis';
$metaDescription = $metaDescription ?? 'KynoCanis - Ihr Partner für Kynologie und Psychologie';
$bodyClass = $bodyClass ?? '';
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?= e($metaDescription) ?>">
    <meta name="robots" content="index, follow">
    <title><?= e($pageTitle) ?> - KynoCanis</title>
    
    <?php 
    // Dynamic Favicon: Only load if uploaded or using logo as favicon
    $useLogo = get_setting('use_logo_as_favicon', false);
    $faviconPath = get_setting('site_favicon', '');
    $logoPath = get_setting('site_logo', '');

    if ($useLogo && !empty($logoPath) && file_exists(MEDIA_ROOT . '/' . $logoPath)): 
    ?>
        <link rel="icon" type="image/x-icon" href="/cms-core/public/webview/media.php?file=<?= e($logoPath) ?>">
    <?php elseif (!empty($faviconPath) && file_exists(MEDIA_ROOT . '/' . $faviconPath)): ?>
        <link rel="icon" type="image/x-icon" href="/cms-core/public/webview/media.php?file=<?= e($faviconPath) ?>">
    <?php endif; ?>
    
    <?php
    // Cache busting for CSS files
    $styleCssVersion = file_exists(__DIR__ . '/../../../assets/css/style.css') ? filemtime(__DIR__ . '/../../../assets/css/style.css') : time();
    $blogCssVersion = file_exists(__DIR__ . '/../../../assets/css/blog-styles.css') ? filemtime(__DIR__ . '/../../../assets/css/blog-styles.css') : time();
    $flexibleCssVersion = file_exists(__DIR__ . '/../assets/css/flexible-blocks.css') ? filemtime(__DIR__ . '/../assets/css/flexible-blocks.css') : time();
    ?>
    
    <!-- 1. Base CSS (your main styles) -->
    <link rel="stylesheet" href="/assets/css/style.css?v=<?= $styleCssVersion ?>">
    <link rel="stylesheet" href="/assets/css/blog-styles.css?v=<?= $blogCssVersion ?>">
    
    <!-- 2. Global Color & Font Styles (farb_font.php - base colors) -->
    <link rel="stylesheet" href="/cms-core/public/webview/global-styles.php?v=<?= time() ?>">
    
    <!-- 3. Flexible Blocks Styles (11 blocks: hero, leistungen, pricing, etc.) -->
    <link rel="stylesheet" href="/cms-core/public/webview/assets/css/flexible-blocks.css?v=<?= $flexibleCssVersion ?>">
    
    <!-- 4. Color Experiment (OVERRIDES base colors if active) -->
    <?php if (file_exists(__DIR__ . '/../../../../customizations/frontend/get-experiment-styles.php')): ?>
        <link rel="stylesheet" href="/customizations/frontend/get-experiment-styles.php?v=<?= time() ?>">
    <?php endif; ?>
    
    <?php 
    // Load tracking scripts only if active
    if (IntegrationHelper::isActive('google_analytics')) {
        echo render_google_analytics();
    }
    if (IntegrationHelper::isActive('tiktok_pixel')) {
        echo render_tiktok_pixel();
    }
    if (IntegrationHelper::isActive('instagram_pixel')) {
        echo render_instagram_pixel();
    }
    ?>
</head>
<body class="<?= e($bodyClass) ?>">
    <?php 
    // Preview banner for admins (if color variant is being previewed)
    if (isset($_COOKIE['color_variant_preview']) && is_logged_in() && is_admin()) {
        if (file_exists(__DIR__ . '/preview_banner.php')) {
            include __DIR__ . '/preview_banner.php';
        }
    }
    ?>
    
    <?php include __DIR__ . '/header.php'; ?>
    
    <main class="main-content" role="main">
        <?= $pageContent ?? '' ?>
    </main>
    
    <?php include __DIR__ . '/footer.php'; ?>
    
    <!-- Cookie Consent Banner -->
    <?php if (IntegrationHelper::isActive('cookie_consent')): ?>
        <?php echo render_cookie_consent(); ?>
    <?php endif; ?>
    
    <script src="/assets/js/main.js"></script>
</body>
</html>