<?php
/** cms-core/public/webview/includes/preview_banner.php */

// Zeige Preview-Banner wenn:
// 1. URL-Parameter ?preview=X gesetzt ist ODER
// 2. Preview-Cookie gesetzt ist
// UND User ist Admin

$previewId = null;

// Priorität 1: URL-Parameter (überschreibt Cookie)
if (isset($_GET['preview'])) {
    $previewId = (int)$_GET['preview'];
}
// Priorität 2: Cookie
elseif (isset($_COOKIE['color_variant_preview'])) {
    $previewId = (int)$_COOKIE['color_variant_preview'];
}

// Nur anzeigen wenn Preview-ID vorhanden und User ist Admin
if ($previewId && is_logged_in() && is_admin()) {
    require_once __DIR__ . '/../../../backend/features/color_experiment.php';
    $variants = ColorExperiment::getAllVariants();
    
    $previewVariant = null;
    foreach ($variants as $v) {
        if ($v['id'] == $previewId) {
            $previewVariant = $v;
            break;
        }
    }
    
    if ($previewVariant):
?>
<div style="position: fixed; top: 0; left: 0; right: 0; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 10px 20px; z-index: 10000; box-shadow: 0 2px 10px rgba(0,0,0,0.3); display: flex; justify-content: space-between; align-items: center;">
    <div style="display: flex; align-items: center; gap: 15px;">
        <span style="font-size: 20px;">👁️</span>
        <div>
            <strong style="font-size: 14px;">Vorschau-Modus:</strong>
            <span style="font-size: 13px; opacity: 0.9;"><?= e($previewVariant['variant_name']) ?></span>
            <span style="font-size: 11px; opacity: 0.7; margin-left: 8px;">(ID: <?= $previewId ?>)</span>
        </div>
        <div style="display: flex; gap: 5px;">
            <div style="width: 20px; height: 20px; border-radius: 50%; border: 2px solid white; background: <?= e($previewVariant['h1_color']) ?>;" title="H1 Farbe"></div>
            <div style="width: 20px; height: 20px; border-radius: 50%; border: 2px solid white; background: linear-gradient(135deg, <?= e($previewVariant['button_gradient_start']) ?>, <?= e($previewVariant['button_gradient_end']) ?>);" title="Button Gradient"></div>
            <div style="width: 20px; height: 20px; border-radius: 50%; border: 2px solid white; background: <?= e($previewVariant['background_block_color']) ?>;" title="Background"></div>
        </div>
    </div>
    <div style="display: flex; gap: 10px;">
        <a href="admin/color_experiment.php" style="background: white; color: #667eea; padding: 6px 12px; border-radius: 5px; text-decoration: none; font-size: 13px; font-weight: 600;">
            ← Zurück zum Admin
        </a>
        <button onclick="endPreview()" style="background: rgba(255,255,255,0.2); color: white; border: 1px solid white; padding: 6px 12px; border-radius: 5px; cursor: pointer; font-size: 13px;">
            ✕ Vorschau beenden
        </button>
    </div>
</div>
<div style="height: 50px;"></div>

<script>
function endPreview() {
    // Lösche Cookie
    document.cookie = 'color_variant_preview=; path=/; max-age=0';
    
    // Entferne Preview-Parameter aus URL
    const url = new URL(window.location);
    url.searchParams.delete('preview');
    url.searchParams.delete('t'); // Auch Timestamp entfernen
    
    // Redirect zur bereinigten URL
    window.location.href = url.toString();
}
</script>

<?php
    endif;
}
?>