<?php
/**
 * cms-core/public/webview/media.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../../backend/core/init.php';

// Get file parameter
$file = $_GET['file'] ?? '';
if (empty($file)) {
    http_response_code(400);
    die('Fehlender Dateipfad');
}

// Validation: Allow pages, blog, uploads, logo, images + svg
if (!preg_match('/^(pages|blog|uploads|logo|images|favicon)\/[a-zA-Z0-9\/_.-]+\.(png|jpg|jpeg|gif|pdf|webp|svg|ico)$/i', $file)) {
    http_response_code(400);
    error_log("Media validation failed: $file");
    die('Ungültiger Dateipfad: ' . htmlspecialchars($file));
}

// FIXED: Use MEDIA_ROOT (not MEDIA_PATH)
$mediaPath = MEDIA_ROOT . '/' . $file;

// Debug logging
error_log("Media Request: $file");
error_log("Full Path: $mediaPath");
error_log("File exists: " . (file_exists($mediaPath) ? 'YES' : 'NO'));

// Check if file exists
if (!file_exists($mediaPath) || !is_file($mediaPath)) {
    error_log("Media 404: File not found at $mediaPath");
    http_response_code(404);
    
    // More helpful error in debug mode
    if (APP_DEBUG) {
        die("Datei nicht gefunden:<br>Requested: $file<br>Full path: $mediaPath<br>MEDIA_ROOT: " . MEDIA_ROOT);
    } else {
        die('Datei nicht gefunden: ' . htmlspecialchars(basename($file)));
    }
}

// Determine MIME type
$extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
$mimeTypes = [
    'png' => 'image/png',
    'jpg' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'gif' => 'image/gif',
    'webp' => 'image/webp',
    'svg' => 'image/svg+xml',
    'pdf' => 'application/pdf',
];
$mime = $mimeTypes[$extension] ?? 'application/octet-stream';

// Security headers
header('Content-Type: ' . $mime);
header('Content-Length: ' . filesize($mediaPath));
header('Cache-Control: public, max-age=86400');
header('X-Content-Type-Options: nosniff');

// Extra security for SVG
if ($extension === 'svg') {
    header('Content-Security-Policy: default-src \'none\'; style-src \'unsafe-inline\'; img-src data:');
}

// Output file
readfile($mediaPath);
exit;