<?php
/** cms-core/public/webview/page.php */

// NO OUTPUT BEFORE THIS LINE!
require_once __DIR__ . '/../../backend/core/init.php';
require_once __DIR__ . '/../../backend/core/FlexibleBlocks.php';

// Get slug from URL
$slug = get_param('slug');

if (empty($slug)) {
    http_response_code(404);
    die('Seite nicht gefunden');
}

// Get page from database
$page = db()->fetchOne("SELECT * FROM pages WHERE slug = ?", [$slug]);

if (!$page) {
    // DEBUG: Show what we searched for
    if (is_admin()) {
        http_response_code(404);
        die("Seite nicht gefunden in Datenbank. Gesucht: slug='$slug'");
    }
    http_response_code(404);
    die('Seite nicht gefunden');
}

// Check if page is published (unless admin is logged in)
if ($page['status'] !== 'published') {
    if (!is_logged_in() || !is_admin()) {
        http_response_code(404);
        die('Seite nicht gefunden');
    }
    $isDraftPreview = true;
}

// Get page blocks
try {
    $blocks = FlexibleBlocks::getPageBlocks($slug);
} catch (Exception $e) {
    error_log("Error loading blocks for slug '$slug': " . $e->getMessage());
    $blocks = [];
}

$pageTitle = $page['title'];
$metaDescription = $page['meta_description'] ?? '';
$bodyClass = 'page-' . $slug;

ob_start();

// Show draft banner for admins
if (isset($isDraftPreview) && $isDraftPreview) {
    ?>
    <div style="position: fixed; top: 0; left: 0; right: 0; background: #f59e0b; color: white; padding: 15px; text-align: center; z-index: 10000; box-shadow: 0 2px 10px rgba(0,0,0,0.3);">
        <strong>⚠️ ENTWURF-VORSCHAU</strong> - Diese Seite ist noch nicht veröffentlicht und nur für Admins sichtbar.
        <a href="/admin/page_flexible_edit.php?slug=<?= e($slug) ?>" style="color: white; text-decoration: underline; margin-left: 15px;">
            → Seite bearbeiten
        </a>
    </div>
    <div style="height: 50px;"></div>
    <?php
}

if (empty($blocks)) {
    ?>
    <section class="page-header">
        <div class="container">
            <h1><?= e($page['title']) ?></h1>
        </div>
    </section>
    
    <section class="content-section">
        <div class="container">
            <p style="text-align: center; color: #6b7280; padding: 40px 0;">
                Diese Seite hat noch keinen Inhalt.
            </p>
            <?php if (is_admin()): ?>
                <div style="text-align: center; background: #fef3c7; padding: 20px; border-radius: 8px; margin: 20px 0;">
                    <p style="color: #92400e; margin-bottom: 15px;">
                        <strong>🔧 Admin-Info:</strong> Diese Seite existiert in der Datenbank, hat aber noch keine Blöcke.
                    </p>
                    <a href="/admin/page_flexible_edit.php?slug=<?= e($slug) ?>" class="btn btn-primary">
                        ✏️ Inhalt bearbeiten
                    </a>
                </div>
            <?php endif; ?>
            
            <?php 
            // Fallback: Check if old file exists in customizations/pages/
            $oldFilePath = APP_ROOT . '/customizations/pages/' . $slug . '.php';
            if (file_exists($oldFilePath) && is_admin()): 
            ?>
                <div style="text-align: center; background: #fef2f2; padding: 20px; border-radius: 8px; margin: 20px 0; border: 2px solid #fca5a5;">
                    <p style="color: #991b1b; margin-bottom: 10px;">
                        <strong>⚠️ Migration benötigt:</strong><br>
                        Es existiert eine alte Datei-Version dieser Seite:<br>
                        <code style="background: #fff; padding: 5px; border-radius: 3px;">/customizations/pages/<?= e($slug) ?>.php</code>
                    </p>
                    <p style="color: #991b1b; font-size: 14px;">
                        Diese Datei wird nicht mehr verwendet. Bitte migriere den Inhalt in das neue Block-System oder lösche die Datei.
                    </p>
                </div>
            <?php endif; ?>
        </div>
    </section>
    <?php
} else {
    // Render blocks
    foreach ($blocks as $block) {
        try {
            echo FlexibleBlocks::renderBlock($block);
        } catch (Exception $e) {
            error_log("Error rendering block {$block['id']} on page '$slug': " . $e->getMessage());
            if (is_admin()) {
                echo '<div style="background: #fee; padding: 20px; margin: 20px; border: 2px solid #f00; border-radius: 8px;">';
                echo '<strong style="color: #c00;">⚠️ Block Rendering Error (Block ID: ' . $block['id'] . '):</strong><br>';
                echo '<code style="display: block; margin-top: 10px; color: #600;">' . e($e->getMessage()) . '</code>';
                echo '</div>';
            }
        }
    }
}

$pageContent = ob_get_clean();
include __DIR__ . '/includes/layout.php';