<?php
/** cms-core/public/webview/rss.php - BLOG RSS FEED */

require_once __DIR__ . '/../../backend/core/init.php';

// Set XML headers
header('Content-Type: application/rss+xml; charset=utf-8');

// Get latest 20 published posts
$posts = db()->fetchAll(
    "SELECT bp.*, u.username as author_name 
     FROM blog_posts bp 
     LEFT JOIN users u ON bp.author_id = u.id 
     WHERE bp.status = 'published'
     ORDER BY bp.published_at DESC
     LIMIT 20"
);

$siteTitle = get_setting('site_title', 'Blog');
$siteDescription = get_setting('site_description', 'Aktuelle Beiträge');
$baseUrl = rtrim(BASE_URL, '/');

// Generate RSS XML
echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">
    <channel>
        <title><?= e($siteTitle) ?></title>
        <link><?= e($baseUrl) ?></link>
        <description><?= e($siteDescription) ?></description>
        <language>de-DE</language>
        <lastBuildDate><?= date(DATE_RSS) ?></lastBuildDate>
        <atom:link href="<?= e($baseUrl) ?>/rss.php" rel="self" type="application/rss+xml" />
        
        <?php foreach ($posts as $post): ?>
        <item>
            <title><?= e($post['title']) ?></title>
            <link><?= e($baseUrl) ?>/blog-post.php?slug=<?= e($post['slug']) ?></link>
            <guid isPermaLink="true"><?= e($baseUrl) ?>/blog-post.php?slug=<?= e($post['slug']) ?></guid>
            <pubDate><?= date(DATE_RSS, strtotime($post['published_at'])) ?></pubDate>
            <author><?= e($post['author_name']) ?></author>
            
            <?php if ($post['excerpt']): ?>
            <description><![CDATA[<?= $post['excerpt'] ?>]]></description>
            <?php else: ?>
            <description><![CDATA[<?= truncate(strip_tags($post['content']), 300) ?>]]></description>
            <?php endif; ?>
            
            <?php if (!empty($post['featured_image'])): ?>
            <enclosure url="<?= e($baseUrl) ?>/media/blog/<?= e($post['featured_image']) ?>" type="image/jpeg" />
            <?php endif; ?>
            
            <content:encoded><![CDATA[<?= $post['content'] ?>]]></content:encoded>
        </item>
        <?php endforeach; ?>
    </channel>
</rss>