<?php
/**
 * robots.txt.php (save as robots.txt.php in root)
 * Environment-aware robots.txt
 * - In development: Blocks all crawlers
 * - In production: Allows all crawlers and references sitemap
 */

require_once __DIR__ . '/cms-core/backend/core/init.php';

header('Content-Type: text/plain; charset=UTF-8');

// Check environment
if (APP_ENV === 'production') {
    // PRODUCTION: Allow all crawlers
    echo "# robots.txt for " . BASE_URL . "\n";
    echo "# Environment: PRODUCTION\n\n";
    echo "User-agent: *\n";
    echo "Allow: /\n\n";
    
    // Disallow admin area
    echo "# Admin area\n";
    echo "Disallow: /admin/\n";
    echo "Disallow: /cms-core/\n\n";
    
    // Disallow config files
    echo "# Config & sensitive files\n";
    echo "Disallow: /.env\n";
    echo "Disallow: /config/\n\n";
    
    // Reference sitemap
    echo "# Sitemap\n";
    echo "Sitemap: " . BASE_URL . "/sitemap.xml\n";
    
} else {
    // DEVELOPMENT: Block all crawlers
    echo "# robots.txt for " . BASE_URL . "\n";
    echo "# Environment: DEVELOPMENT\n\n";
    echo "# DEVELOPMENT MODE - BLOCKING ALL CRAWLERS\n\n";
    echo "User-agent: *\n";
    echo "Disallow: /\n";
}
?>